/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("origin") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("origin, o, source, shooter, s")) {
                scriptEntry.addObject("origin", arg.asType(dEntity.class).setPrefix("entity"));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration, d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("speed, s")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("height, h")) {
                scriptEntry.addObject("height", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("script") || !arg.matchesArgumentType(dScript.class)) continue;
            scriptEntry.addObject("script", arg.asType(dScript.class));
        }
        scriptEntry.defaultObject("origin", scriptEntry.hasNPC() ? scriptEntry.getNPC().getDenizenEntity() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity() : null);
        scriptEntry.defaultObject("speed", new Element(1.5));
        scriptEntry.defaultObject("height", new Element(0));
        scriptEntry.defaultObject("duration", Duration.valueOf("80t"));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "entities");
        }
        if (!scriptEntry.hasObject("origin")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ORIGIN");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dEntity shooter = (dEntity)scriptEntry.getObject("origin");
        LivingEntity shooterEntity = shooter.getLivingEntity();
        final dLocation destination = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : new dLocation(shooterEntity.getEyeLocation().add(shooterEntity.getEyeLocation().getDirection().multiply(40)));
        List entities = (List)scriptEntry.getObject("entities");
        final Element speed = (Element)scriptEntry.getObject("speed");
        final dScript script = (dScript)scriptEntry.getObject("script");
        double height = ((Element)scriptEntry.getObject("height")).asDouble();
        final int maxTicks = ((Duration)scriptEntry.getObject("duration")).getTicksAsInt() / 2;
        dB.report(this.getName(), aH.debugObj("origin", shooter) + aH.debugObj("entities", entities.toString()) + aH.debugObj("destination", destination) + aH.debugObj("speed", speed) + (script != null ? aH.debugObj("script", script) : ""));
        if (shooter.identify().startsWith("n@") || !Rotation.isFacingLocation((Entity)shooterEntity, (Location)destination, 45.0f)) {
            Rotation.faceLocation((Entity)shooterEntity, destination);
        }
        Location origin = shooterEntity.getEyeLocation().add(shooterEntity.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0);
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) {
                entity.spawnAt(origin);
            } else {
                entity.teleport(origin);
            }
            Rotation.faceLocation(entity.getBukkitEntity(), destination);
            if (!(entity.getBukkitEntity() instanceof Projectile)) continue;
            ((Projectile)entity.getBukkitEntity()).setShooter(shooter.getLivingEntity());
        }
        Position.mount(Conversion.convert(entities));
        final Entity lastEntity = ((dEntity)entities.get(entities.size() - 1)).getBukkitEntity();
        BukkitRunnable task = new BukkitRunnable(){
            int runs = 0;

            public void run() {
                if (this.runs < maxTicks && lastEntity.isValid()) {
                    Vector v1 = lastEntity.getLocation().toVector();
                    Vector v2 = destination.toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(speed.asDouble());
                    lastEntity.setVelocity(v3);
                    ++this.runs;
                    if (Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        this.runs = maxTicks;
                    }
                    if (!lastEntity.getLocation().add(v3).getBlock().getType().toString().equals("AIR")) {
                        this.runs = maxTicks;
                    }
                } else {
                    this.cancel();
                    this.runs = 0;
                    if (script != null) {
                        HashMap<String, String> context = new HashMap<String, String>();
                        context.put("1", lastEntity.getLocation().getX() + "," + lastEntity.getLocation().getY() + "," + lastEntity.getLocation().getZ() + "," + lastEntity.getLocation().getWorld().getName());
                        context.put("2", "e@" + lastEntity.getEntityId());
                        ((TaskScriptContainer)script.getContainer()).setSpeed(new Duration(0)).runTaskScript(scriptEntry.getPlayer(), scriptEntry.getNPC(), context);
                    }
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, 2L);
    }
}

