/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class TakeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TakeType takeType = null;
        double quantity = 1.0;
        dItem item = null;
        boolean npc = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("MONEY, COINS", arg)) {
                takeType = TakeType.MONEY;
                continue;
            }
            if (aH.matchesArg("ITEM_IN_HAND, ITEMINHAND", arg)) {
                takeType = TakeType.ITEMINHAND;
                continue;
            }
            if (aH.matchesArg("INVENTORY", arg)) {
                takeType = TakeType.INVENTORY;
                continue;
            }
            if (aH.matchesArg("NPC", arg)) {
                npc = true;
                continue;
            }
            if (aH.matchesValueArg("QTY", arg, aH.ArgumentType.Double)) {
                quantity = aH.getDoubleFrom(arg);
                continue;
            }
            if (aH.matchesItem(arg) || aH.matchesItem("item:" + arg)) {
                takeType = TakeType.ITEM;
                item = dItem.valueOf(aH.getStringFrom(arg), scriptEntry.getPlayer(), scriptEntry.getNPC());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("item", item).addObject("takeType", (Object)takeType).addObject("quantity", quantity).addObject("npc", npc);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        boolean npc = (Boolean)scriptEntry.getObject("npc");
        TakeType type = (TakeType)((Object)scriptEntry.getObject("takeType"));
        Double quantity = (Double)scriptEntry.getObject("quantity");
        dItem item = (dItem)scriptEntry.getObject("item");
        dB.report(this.getName(), aH.debugObj("Type", type.name()) + aH.debugObj("Quantity", String.valueOf(quantity)) + (type == TakeType.INVENTORY && npc ? aH.debugObj("NPC", "true") : ""));
        switch (type) {
            case INVENTORY: {
                if (npc) {
                    scriptEntry.getNPC().getEntity().getEquipment().clear();
                    break;
                }
                scriptEntry.getPlayer().getPlayerEntity().getInventory().clear();
                break;
            }
            case ITEMINHAND: {
                int inHandAmt = scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getAmount();
                int theAmount = ((Double)scriptEntry.getObject("quantity")).intValue();
                ItemStack newHandItem = new ItemStack(0);
                if (theAmount > inHandAmt) {
                    dB.echoDebug("...player did not have enough of the item in hand, so Denizen just took as many as it could. To avoid this situation, use an IF <PLAYER.ITEM_IN_HAND.QTY>.");
                    scriptEntry.getPlayer().getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                if (theAmount == inHandAmt) {
                    scriptEntry.getPlayer().getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                newHandItem = new ItemStack(scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getType(), inHandAmt - theAmount, (short)scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getData().getData());
                newHandItem.setItemMeta(scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getItemMeta());
                scriptEntry.getPlayer().getPlayerEntity().setItemInHand(newHandItem);
                scriptEntry.getPlayer().getPlayerEntity().updateInventory();
                break;
            }
            case MONEY: {
                if (Depends.economy != null) {
                    double amount = (Double)scriptEntry.getObject("quantity");
                    dB.echoDebug("...taking " + amount + " money.");
                    Depends.economy.withdrawPlayer(scriptEntry.getPlayer().getName(), amount);
                    break;
                }
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case ITEM: {
                ItemStack is = item.getItemStack();
                is.setAmount(quantity.intValue());
                dInventory inventory = new dInventory((Inventory)scriptEntry.getPlayer().getPlayerEntity().getInventory());
                if (item.getItemStack().getItemMeta() instanceof BookMeta) {
                    inventory.removeBook(is);
                    break;
                }
                if (inventory.getInventory().removeItem(new ItemStack[]{is}).isEmpty()) break;
                dB.echoDebug("The Player did not have enough " + is.getType().toString() + " on hand, so Denizen took as much as possible. To avoid this situation, use an IF or REQUIREMENT to check.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TakeType {
        MONEY,
        ITEMINHAND,
        ITEM,
        INVENTORY;

    }
}

