/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.SavesReloadEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class ViewerCommand
extends AbstractCommand
implements Listener {
    static Map<String, Viewer> viewers = new ConcurrentHashMap<String, Viewer>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("display") && arg.matchesEnum(Display.values())) {
                scriptEntry.addObject("display", (Object)Display.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesPrefix("i, id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("location") || !arg.matchesArgumentType(dLocation.class)) continue;
            scriptEntry.addObject("location", arg.asType(dLocation.class).setPrefix("location"));
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", (Object)Action.CREATE);
        }
        if (!scriptEntry.hasObject("display")) {
            scriptEntry.addObject("display", (Object)Display.LOCATION);
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify a Viewer ID!");
        }
        if (!scriptEntry.hasObject("location") && scriptEntry.getObject("action").equals((Object)Action.CREATE)) {
            throw new InvalidArgumentsException("Must specify a Sign location!");
        }
        if (!scriptEntry.hasObject("type")) {
            scriptEntry.addObject("type", (Object)Type.SIGN_POST);
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Display display = (Display)((Object)scriptEntry.getObject("display"));
        String id = scriptEntry.getObject("id").toString();
        dLocation location = (dLocation)scriptEntry.getObject("location");
        String content = display.toString() + "; " + scriptEntry.getPlayer().getName();
        switch (action) {
            case CREATE: {
                if (viewers.containsKey(id)) {
                    dB.echoDebug("Viewer ID " + id + " already exists!");
                    return;
                }
                Viewer viewer = new Viewer(id, content, location);
                viewers.put(id, viewer);
                Block sign = location.getBlock();
                sign.setType(Material.valueOf((String)type.name()));
                final BlockState signState = sign.getState();
                Utilities.setSignRotation(signState);
                int task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    public void run() {
                        Player player = Bukkit.getPlayerExact((String)scriptEntry.getPlayer().getName());
                        if (player == null) {
                            Utilities.setSignLines((Sign)signState, new String[]{"", scriptEntry.getPlayer().getName(), "is offline.", ""});
                        } else {
                            Utilities.setSignLines((Sign)signState, new String[]{String.valueOf(scriptEntry.getPlayer().getLocation().getX()), String.valueOf(scriptEntry.getPlayer().getLocation().getY()), String.valueOf(scriptEntry.getPlayer().getLocation().getZ()), scriptEntry.getPlayer().getWorld().getName()});
                        }
                    }
                }, 0L, 20L);
                viewer.setTask(task);
                viewer.save();
                break;
            }
            case MODIFY: {
                break;
            }
            case REMOVE: {
                if (!viewers.containsKey(id)) {
                    dB.echoDebug("Viewer ID " + id + " doesn't exist!");
                    return;
                }
                Block block = ViewerCommand.viewers.get(id).getLocation().getBlock();
                block.setType(Material.AIR);
                Bukkit.getScheduler().cancelTask(ViewerCommand.viewers.get(id).getTask());
                viewers.get(id).remove();
                viewers.remove(id);
            }
        }
    }

    @EventHandler
    public static void reloadViewers(SavesReloadEvent event) {
        for (Viewer viewer : viewers.values()) {
            Bukkit.getScheduler().cancelTask(viewer.getTask());
        }
        viewers.clear();
        FileConfiguration saves = DenizenAPI.getCurrentInstance().getSaves();
        if (saves.contains("Viewers")) {
            for (String key : saves.getConfigurationSection("Viewers").getKeys(false)) {
                Viewer viewer = new Viewer(key, saves.getString("Viewers." + key.toLowerCase() + ".content"), dLocation.valueOf(saves.getString("Viewers." + key.toLowerCase() + ".location")));
                viewers.put(key, viewer);
                final Sign sign = (Sign)viewer.getLocation().getBlock().getState();
                final String[] content = viewer.getContent().split("; ");
                if (!viewer.getContent().startsWith("location")) continue;
                int task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    public void run() {
                        Player player = Bukkit.getPlayerExact((String)content[1]);
                        if (player == null) {
                            Utilities.setSignLines(sign, new String[]{"", content[1], "is offline.", ""});
                        } else {
                            Utilities.setSignLines(sign, new String[]{String.valueOf(player.getLocation().getX()), String.valueOf(player.getLocation().getY()), String.valueOf(player.getLocation().getZ()), player.getWorld().getName()});
                        }
                    }
                }, 0L, 20L);
                viewer.setTask(task);
            }
        } else {
            return;
        }
    }

    @EventHandler
    public static void blockBreaks(BlockBreakEvent event) {
        dLocation location = new dLocation(event.getBlock().getLocation());
        for (Viewer viewer : viewers.values()) {
            if (!Utilities.isBlock(location, viewer.getLocation())) continue;
            event.getPlayer().sendMessage(ChatColor.RED + "You're not allowed to break that sign.");
            event.setCancelled(true);
        }
    }

    public void onEnable() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void onDisable() {
        for (Viewer viewer : viewers.values()) {
            viewer.save();
        }
    }

    private static class Viewer {
        private String id;
        private String content;
        private dLocation location;
        private int task;

        private Viewer(String id) {
            this.id = id;
        }

        private Viewer(String id, String content, dLocation location) {
            this.id = id;
            this.content = content;
            this.location = location;
        }

        void setContent(String content) {
            this.content = content;
        }

        void setLocation(dLocation location) {
            this.location = location;
        }

        void setTask(int task) {
            this.task = task;
        }

        private String getContent() {
            return this.content;
        }

        private dLocation getLocation() {
            return this.location;
        }

        private int getTask() {
            return this.task;
        }

        void save() {
            FileConfiguration saves = DenizenAPI.getCurrentInstance().getSaves();
            saves.set("Viewers." + this.id.toLowerCase() + ".content", (Object)this.content);
            saves.set("Viewers." + this.id.toLowerCase() + ".location", (Object)this.location.identify());
        }

        void remove() {
            FileConfiguration saves = DenizenAPI.getCurrentInstance().getSaves();
            saves.set("Viewers." + this.id.toLowerCase(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Display {
        LOCATION,
        SCORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SIGN_POST,
        WALL_SIGN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        CREATE,
        MODIFY,
        REMOVE;

    }
}

