/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    static final Pattern triggerPattern = Pattern.compile("\\/([^/]*)\\/");

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void chatTrigger(final AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        boolean wasInterrupted = Thread.interrupted();
        Callable<Boolean> call = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                InteractScriptContainer script;
                dNPC npc = Utilities.getClosestNPC(event.getPlayer().getLocation(), 25);
                dPlayer player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
                if (npc == null) {
                    return null;
                }
                if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
                    return null;
                }
                if (!((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(ChatTrigger.this.name)) {
                    return null;
                }
                if (npc.getTriggerTrait().getRadius(ChatTrigger.this.name) < npc.getLocation().distance(event.getPlayer().getLocation())) {
                    return null;
                }
                dB.report(ChatTrigger.this.name, aH.debugObj("Player", event.getPlayer().getName()) + aH.debugObj("NPC", npc.toString()) + aH.debugObj("Radius(Max)", npc.getLocation().distance(event.getPlayer().getLocation()) + "(" + npc.getTriggerTrait().getRadius(ChatTrigger.this.name) + ")") + aH.debugObj("Trigger text", event.getMessage()) + aH.debugObj("LOS", String.valueOf(npc.getEntity().hasLineOfSight((Entity)event.getPlayer()))) + aH.debugObj("Facing", String.valueOf(Rotation.isFacingEntity((Entity)event.getPlayer(), (Entity)npc.getEntity(), 45.0f))));
                if (Settings.ChatMustLookAtNPC() && !Rotation.isFacingEntity((Entity)event.getPlayer(), (Entity)npc.getEntity(), 45.0f)) {
                    return null;
                }
                Boolean ret = null;
                if (!npc.getTriggerTrait().trigger(ChatTrigger.this, player)) {
                    if (Settings.ChatGloballyIfUninteractable()) {
                        dB.echoDebug(ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                        return null;
                    }
                    ret = true;
                }
                if (!(script = npc.getInteractScript(player, ChatTrigger.class)).containsTriggerInStep(InteractScriptHelper.getCurrentStep(player, script.getName()), ChatTrigger.class)) {
                    if (!Settings.ChatGloballyIfNoChatTriggers()) {
                        dB.echoDebug(event.getPlayer().getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + event.getMessage());
                        return true;
                    }
                    return ret;
                }
                String id = null;
                boolean matched = false;
                String replacementText = null;
                String regexId = null;
                String regexMessage = null;
                Map<Object, Object> idMap = new HashMap();
                if (script != null) {
                    idMap = script.getIdMapFor(ChatTrigger.class, player);
                }
                if (!idMap.isEmpty()) {
                    for (Map.Entry entry : idMap.entrySet()) {
                        Matcher matcher = triggerPattern.matcher((CharSequence)entry.getValue());
                        while (matcher.find()) {
                            if (!script.checkSpecificTriggerScriptRequirementsFor(ChatTrigger.class, player, npc, (String)entry.getKey())) continue;
                            String keyword = TagManager.tag(player, npc, matcher.group().replace("/", ""));
                            if (ChatTrigger.this.isKeywordRegex(keyword)) {
                                Pattern pattern = Pattern.compile(keyword.substring(6));
                                Matcher m = pattern.matcher(event.getMessage());
                                if (!m.find()) continue;
                                regexId = (String)entry.getKey();
                                regexMessage = ((String)entry.getValue()).replace(matcher.group(), m.group());
                                dB.log("entry value: " + (String)entry.getValue() + "  keyword: " + keyword + "  m.group: " + m.group() + "  matcher.group: " + matcher.group());
                                continue;
                            }
                            if (ChatTrigger.this.isKeywordStrict(keyword)) {
                                if (!event.getMessage().toUpperCase().equalsIgnoreCase(keyword.toUpperCase())) continue;
                                id = (String)entry.getKey();
                                replacementText = ((String)entry.getValue()).replace("/", "");
                                matched = true;
                                continue;
                            }
                            if (!event.getMessage().toUpperCase().contains(keyword.toUpperCase())) continue;
                            id = (String)entry.getKey();
                            replacementText = ((String)entry.getValue()).replace("/", "");
                            matched = true;
                        }
                        if (!matched) continue;
                        break;
                    }
                }
                if (!matched && regexId != null) {
                    id = regexId;
                    replacementText = regexMessage;
                }
                if (id != null) {
                    Utilities.talkToNPC(replacementText, player, npc, Settings.ChatToNpcOverhearingRange());
                    ChatTrigger.this.parse(npc, player, script, id);
                    return true;
                }
                if (!Settings.ChatGloballyIfFailedChatTriggers()) {
                    Utilities.talkToNPC(event.getMessage(), player, npc, Settings.ChatToNpcOverhearingRange());
                    return true;
                }
                return ret;
            }
        };
        Boolean cancelled = null;
        try {
            cancelled = event.isAsynchronous() ? (Boolean)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get() : (Boolean)call.call();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        if (cancelled == null) {
            return;
        }
        event.setCancelled(cancelled.booleanValue());
    }

    private boolean isKeywordRegex(String keyWord) {
        return keyWord.toUpperCase().startsWith("REGEX:");
    }

    private boolean isKeywordStrict(String keyWord) {
        return keyWord.toUpperCase().startsWith("STRICT:");
    }
}

