/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration, d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("amplifier") && (arg.matchesPrimitive(aH.PrimitiveType.Integer) || arg.matchesPrimitive(aH.PrimitiveType.Double)) && arg.matchesPrefix("power, p")) {
                scriptEntry.addObject("amplifier", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (scriptEntry.hasObject("effect") || !arg.matchesPrimitive(aH.PrimitiveType.String)) continue;
            if (PotionEffectType.getByName((String)arg.asElement().asString()) == null) {
                dB.echoError("Invalid PotionEffectType!");
                continue;
            }
            scriptEntry.addObject("effect", PotionEffectType.getByName((String)arg.asElement().asString()));
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new Duration(60));
        }
        if (!scriptEntry.hasObject("entities")) {
            ArrayList<dEntity> entities = new ArrayList<dEntity>();
            if (scriptEntry.getPlayer() != null) {
                entities.add(scriptEntry.getPlayer().getDenizenEntity());
            } else if (scriptEntry.getNPC() != null) {
                entities.add(scriptEntry.getNPC().getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("No valid target entities found!");
            }
            scriptEntry.addObject("entities", entities);
        }
        if (!scriptEntry.hasObject("effect")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "PotionType");
        }
        if (!scriptEntry.hasObject("amplifier")) {
            scriptEntry.addObject("amplifier", new Element(1));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        PotionEffectType effect = (PotionEffectType)scriptEntry.getObject("effect");
        int amplifier = ((Element)scriptEntry.getObject("amplifier")).asInt();
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dB.report(this.getName(), aH.debugObj("Target(s)", entities.toString()) + aH.debugObj("Effect", effect.getName()) + aH.debugObj("Amplifier", amplifier) + duration.debug());
        for (dEntity entity : entities) {
            PotionEffect potion = new PotionEffect(effect, duration.getTicksAsInt(), amplifier);
            if (potion.apply(entity.getLivingEntity())) continue;
            dB.echoError("Bukkit was unable to apply '" + potion.getType().getName() + "' to '" + entity.toString() + "'.");
        }
    }
}

