/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.actions.ActionHandler;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dNPCRegistry
implements Listener {
    public static Map<Integer, dNPC> denizenNPCs = new ConcurrentHashMap<Integer, dNPC>(8, 0.9f, 1);
    private Denizen plugin;
    private ActionHandler actionHandler;

    public static dNPCRegistry getCurrentInstance() {
        return DenizenAPI.getCurrentInstance().getNPCRegistry();
    }

    public dNPCRegistry(Denizen denizen) {
        this.plugin = denizen;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.actionHandler = new ActionHandler(this.plugin);
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    private boolean _isRegistered(NPC npc) {
        return denizenNPCs.containsKey(npc);
    }

    private void _registerNPC(NPC npc) {
        if (npc == null) {
            return;
        }
        if (!denizenNPCs.containsKey(npc.getId())) {
            denizenNPCs.put(npc.getId(), new dNPC(npc));
        }
    }

    public dNPC getDenizen(NPC npc) {
        if (npc == null) {
            return null;
        }
        if (!denizenNPCs.containsKey(npc.getId())) {
            this._registerNPC(npc);
        }
        return denizenNPCs.get(npc.getId());
    }

    public Set<dNPC> getSpawnedNPCs() {
        Iterator<Map.Entry<Integer, dNPC>> it = denizenNPCs.entrySet().iterator();
        HashSet<dNPC> npcs = new HashSet<dNPC>();
        while (it.hasNext()) {
            Map.Entry<Integer, dNPC> npc = it.next();
            if (npc.getValue().getCitizen() == null) {
                dB.log(ChatColor.RED + "Removed NPC from dRegistry.");
                try {
                    denizenNPCs.remove(npc.getKey());
                }
                catch (Exception e) {
                    dB.echoDebug("Report this error to aufdemrand! Err: posconcurrency1");
                }
                continue;
            }
            if (!npc.getValue().isSpawned()) continue;
            npcs.add(npc.getValue());
        }
        return npcs;
    }

    @EventHandler
    public void onSpawn(NPCSpawnEvent event) {
        this._registerNPC(event.getNPC());
        WorldScriptHelper.doEvents(Arrays.asList("npc spawns"), dNPC.mirrorCitizensNPC(event.getNPC()), null, null).toUpperCase();
        this.plugin.getNPCRegistry().getDenizen(event.getNPC()).action("spawn", null);
    }

    @EventHandler
    public void despawn(NPCDespawnEvent event) {
        WorldScriptHelper.doEvents(Arrays.asList("npc despawns"), dNPC.mirrorCitizensNPC(event.getNPC()), null, null).toUpperCase();
        this.plugin.getNPCRegistry().getDenizen(event.getNPC()).action("despawn", null);
    }

    @EventHandler
    public void onRemove(NPCRemoveEvent event) {
        this.plugin.getNPCRegistry().getDenizen(event.getNPC()).action("remove", null);
        if (this._isRegistered(event.getNPC())) {
            denizenNPCs.remove(event.getNPC());
        }
        dB.log(ChatColor.RED + "Deconstructing Denizen NPC " + event.getNPC().getName() + "/" + event.getNPC().getId());
    }
}

