/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class RandomCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int possibilities = 1;
        ScriptQueue queue = scriptEntry.getResidingQueue();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesInteger(arg)) {
                possibilities = aH.getIntegerFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (possibilities <= 1) {
            throw new InvalidArgumentsException("Must randomly select more than one item.");
        }
        if (queue.getQueueSize() < possibilities) {
            throw new InvalidArgumentsException("Invalid Size! RANDOM [#] must not be larger than the script!");
        }
        scriptEntry.addObject("possibilities", possibilities);
        scriptEntry.addObject("queue", queue);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Integer possibilities = (Integer)scriptEntry.getObject("possibilities");
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        int selected = Utilities.getRandom().nextInt(possibilities);
        ScriptEntry keeping = null;
        dB.echoDebug("...random number generator selected '%s'", String.valueOf(selected + 1));
        for (int x = 0; x < possibilities; ++x) {
            if (x != selected) {
                dB.echoDebug("...removing '%s'", queue.getEntry(0).getCommandName());
                queue.removeEntry(0);
                continue;
            }
            dB.echoDebug("...selected '%s'", queue.getEntry(0).getCommandName() + ": " + queue.getEntry(0).getArguments());
            keeping = queue.getEntry(0);
            queue.removeEntry(0);
        }
        queue.injectEntry(keeping, 0);
    }
}

