/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Color;

public class dColor
implements dObject {
    static final Pattern rgbPattern = Pattern.compile("(\\d+)[,:](\\d+)[,:](\\d+)");
    private Color color;
    String prefix = "color";

    @ObjectFetcher(value="co")
    public static dColor valueOf(String string) {
        if ((string = string.toUpperCase().replace("CO@", "")).matches("RANDOM")) {
            return new dColor(Utilities.getRandom().nextInt(256), Utilities.getRandom().nextInt(256), Utilities.getRandom().nextInt(256));
        }
        Matcher m = rgbPattern.matcher(string);
        if (m.matches()) {
            return new dColor(aH.getIntegerFrom(m.group(1)), aH.getIntegerFrom(m.group(2)), aH.getIntegerFrom(m.group(3)));
        }
        Field colorField = null;
        try {
            colorField = Color.class.getField(string.toUpperCase());
        }
        catch (SecurityException e1) {
            dB.echoError("Security exception getting color field!");
        }
        catch (NoSuchFieldException e1) {
            dB.echoError("No such color field!");
        }
        if (colorField != null) {
            return new dColor(colorField);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if ((arg = arg.toUpperCase().replace("CO@", "")).toUpperCase().matches("RANDOM")) {
            return true;
        }
        Matcher m = rgbPattern.matcher(arg);
        if (m.matches()) {
            return true;
        }
        for (Field field : Color.class.getFields()) {
            if (!arg.toUpperCase().matches(field.getName())) continue;
            return true;
        }
        return false;
    }

    public dColor(int red, int green, int blue) {
        this.color = Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public dColor(Field field) {
        try {
            this.color = (Color)field.get(null);
        }
        catch (IllegalArgumentException e) {
            dB.echoError("Illegal argument for color!");
        }
        catch (IllegalAccessException e) {
            dB.echoError("Illegal access for color!");
        }
    }

    public dColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getType() {
        return "Color";
    }

    public String identify() {
        return "co@" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue();
    }

    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public String getAttribute(Attribute attribute) {
        return new Element(this.identify()).getAttribute(attribute);
    }
}

