/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.midi;

import javax.sound.midi.ShortMessage;

public class ToneUtil {
    public static double noteToPitch(byte note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    public static byte midiToNote(ShortMessage smsg) {
        int semitone = smsg.getData1();
        if (semitone < 54) {
            return (byte)((semitone - 6) % 12);
        }
        if (semitone > 78) {
            return (byte)((semitone - 6) % 12 + 12);
        }
        return (byte)(semitone - 54);
    }

    public static double midiToPitch(ShortMessage smsg) {
        return ToneUtil.noteToPitch(ToneUtil.midiToNote(smsg));
    }
}

