/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Rotation;

public class LookCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (scriptEntry.hasObject("entities") || !arg.matchesArgumentList(dEntity.class)) continue;
            scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
        }
        scriptEntry.defaultObject("entities", scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null, scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null);
        if (!scriptEntry.hasObject("location") || !scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify a location and entity!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation loc = (dLocation)scriptEntry.getObject("location");
        List entities = (List)scriptEntry.getObject("entities");
        dB.report(this.getName(), loc.debug() + aH.debugObj("entities", entities.toString()));
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            Rotation.faceLocation(entity.getBukkitEntity(), loc);
        }
    }
}

