/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LeashHitch;

public class LeashCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel, stop")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("holder") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("holder, h")) {
                scriptEntry.addObject("holder", arg.asType(dEntity.class));
                continue;
            }
            if (scriptEntry.hasObject("holder") || !arg.matchesArgumentType(dLocation.class) || !arg.matchesPrefix("holder, h")) continue;
            scriptEntry.addObject("holder", arg.asType(dLocation.class));
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ENTITIES");
        }
        if (!scriptEntry.hasObject("cancel")) {
            scriptEntry.defaultObject("holder", scriptEntry.hasNPC() ? scriptEntry.getNPC().getDenizenEntity() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity() : null);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dEntity holder = null;
        dLocation holderLoc = null;
        Entity Holder2 = null;
        Object holderObject = scriptEntry.getObject("holder");
        if (holderObject instanceof dEntity) {
            holder = (dEntity)scriptEntry.getObject("holder");
            Holder2 = holder.getBukkitEntity();
        } else if (holderObject instanceof dLocation) {
            holderLoc = (dLocation)scriptEntry.getObject("holder");
            if (holderLoc.getBlock().getType() == Material.FENCE || holderLoc.getBlock().getType() == Material.NETHER_FENCE) {
                Holder2 = holderLoc.getWorld().spawn((Location)holderLoc, LeashHitch.class);
            } else {
                dB.echoError("Bad holder location specified - only fences are permitted!");
                return;
            }
        }
        boolean cancel = scriptEntry.hasObject("cancel");
        dB.report(this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("entities", entities.toString()) + (holder != null ? aH.debugObj("holder", holder) : aH.debugObj("holder", holderLoc)));
        for (dEntity entity : entities) {
            if (!entity.isSpawned() || !entity.isLivingEntity()) continue;
            if (cancel) {
                entity.getLivingEntity().setLeashHolder(null);
                continue;
            }
            entity.getLivingEntity().setLeashHolder(Holder2);
        }
    }
}

