/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.queues;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.CommandExecuter;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.Delayable;
import net.aufdemrand.denizen.scripts.requirements.RequirementChecker;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ScriptEngine {
    private final Denizen denizen;
    private final RequirementChecker requirementChecker;
    private final CommandExecuter commandExecuter;

    public ScriptEngine(Denizen denizenPlugin) {
        this.denizen = denizenPlugin;
        this.commandExecuter = new CommandExecuter(this.denizen);
        this.requirementChecker = new RequirementChecker(this.denizen);
    }

    public void revolve(ScriptQueue scriptQueue) {
        if (scriptQueue.getLastEntryExecuted() != null && scriptQueue.getLastEntryExecuted().shouldWaitFor() && !scriptQueue.getLastEntryExecuted().isDone()) {
            return;
        }
        ScriptEntry scriptEntry = scriptQueue.getNext();
        while (scriptEntry != null) {
            scriptEntry.setSendingQueue(scriptQueue);
            try {
                this.getScriptExecuter().execute(scriptEntry);
            }
            catch (Throwable e) {
                dB.echoError("Woah! An exception has been called with this command!");
                if (!dB.showStackTraces) {
                    dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                }
                e.printStackTrace();
            }
            scriptQueue.setLastEntryExecuted(scriptEntry);
            if (scriptQueue instanceof Delayable && ((Delayable)((Object)scriptQueue)).isDelayed() || !scriptEntry.isInstant()) break;
            scriptEntry = scriptQueue.getNext();
        }
    }

    public RequirementChecker getRequirementChecker() {
        return this.requirementChecker;
    }

    public CommandExecuter getScriptExecuter() {
        return this.commandExecuter;
    }
}

