/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("qty") && arg.matchesPrefix("q, qty, quantity") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("money, coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp, exp, experience")) {
                scriptEntry.addObject("type", (Object)Type.EXP);
                continue;
            }
            if (!scriptEntry.hasObject("engrave") && arg.matches("engrave")) {
                scriptEntry.addObject("engrave", Element.TRUE);
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(dItem.class)) {
                scriptEntry.addObject("items", dList.valueOf(arg.raw_value.replace("item:", "")).filter(dItem.class));
                continue;
            }
            if (scriptEntry.hasObject("inventory") || !arg.matchesPrefix("t, to") || !arg.matchesArgumentType(dInventory.class)) continue;
            scriptEntry.addObject("inventory", arg.asType(dInventory.class));
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("engrave", Element.FALSE).defaultObject("inventory", scriptEntry.hasPlayer() ? new dInventory(scriptEntry.getPlayer().getPlayerEntity()) : null).defaultObject("qty", new Element(1));
        if (scriptEntry.getObject("type") == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ITEMS");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element engrave = scriptEntry.getElement("engrave");
        dInventory inventory = (dInventory)scriptEntry.getObject("inventory");
        Element qty = scriptEntry.getElement("qty");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        dB.report(this.getName(), aH.debugObj("Type", type.name()) + aH.debugObj("Quantity", qty.asDouble()) + engrave.debug() + (items != null ? aH.debugObj("Items", items) : ""));
        switch (type) {
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.depositPlayer(scriptEntry.getPlayer().getName(), qty.asDouble());
                    break;
                }
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case EXP: {
                scriptEntry.getPlayer().getPlayerEntity().giveExp(qty.asInt());
                break;
            }
            case ITEM: {
                for (dItem item : items) {
                    HashMap<Integer, ItemStack> leftovers;
                    ItemStack is = item.getItemStack();
                    is.setAmount(qty.asInt());
                    if (engrave.asBoolean()) {
                        is = CustomNBT.addCustomNBT(item.getItemStack(), "owner", scriptEntry.getPlayer().getName());
                    }
                    if ((leftovers = inventory.addWithLeftovers(is)).isEmpty()) continue;
                    dB.echoDebug("The inventory didn't have enough space, the rest of the items have been placed on the floor.");
                    for (ItemStack leftoverItem : leftovers.values()) {
                        inventory.getLocation().getWorld().dropItem((Location)inventory.getLocation(), leftoverItem);
                    }
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        ITEM,
        MONEY,
        EXP;

    }
}

