/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.javaluator;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import net.aufdemrand.denizen.utilities.javaluator.AbstractEvaluator;
import net.aufdemrand.denizen.utilities.javaluator.BracketPair;
import net.aufdemrand.denizen.utilities.javaluator.Constant;
import net.aufdemrand.denizen.utilities.javaluator.Function;
import net.aufdemrand.denizen.utilities.javaluator.Operator;
import net.aufdemrand.denizen.utilities.javaluator.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleEvaluator
extends AbstractEvaluator<Double> {
    public static final Constant PI = new Constant("pi");
    public static final Constant E = new Constant("e");
    public static final Function CEIL = new Function("ceil", 1);
    public static final Function FLOOR = new Function("floor", 1);
    public static final Function ROUND = new Function("round", 1);
    public static final Function ABS = new Function("abs", 1);
    public static final Function SINE = new Function("sin", 1);
    public static final Function COSINE = new Function("cos", 1);
    public static final Function TANGENT = new Function("tan", 1);
    public static final Function ACOSINE = new Function("acos", 1);
    public static final Function ASINE = new Function("asin", 1);
    public static final Function ATAN = new Function("atan", 1);
    public static final Function SINEH = new Function("sinh", 1);
    public static final Function COSINEH = new Function("cosh", 1);
    public static final Function TANGENTH = new Function("tanh", 1);
    public static final Function MIN = new Function("min", 1, Integer.MAX_VALUE);
    public static final Function MAX = new Function("max", 1, Integer.MAX_VALUE);
    public static final Function SUM = new Function("sum", 1, Integer.MAX_VALUE);
    public static final Function AVERAGE = new Function("avg", 1, Integer.MAX_VALUE);
    public static final Function LN = new Function("ln", 1);
    public static final Function LOG = new Function("log", 1);
    public static final Function RANDOM = new Function("random", 0);
    public static final Operator NEGATE = new Operator("-", 1, Operator.Associativity.RIGHT, 3);
    public static final Operator NEGATE_HIGH = new Operator("-", 1, Operator.Associativity.RIGHT, 5);
    public static final Operator MINUS = new Operator("-", 2, Operator.Associativity.LEFT, 1);
    public static final Operator PLUS = new Operator("+", 2, Operator.Associativity.LEFT, 1);
    public static final Operator MULTIPLY = new Operator("*", 2, Operator.Associativity.LEFT, 2);
    public static final Operator DIVIDE = new Operator("/", 2, Operator.Associativity.LEFT, 2);
    public static final Operator EXPONENT = new Operator("^", 2, Operator.Associativity.LEFT, 4);
    public static final Operator MODULO = new Operator("%", 2, Operator.Associativity.LEFT, 2);
    private static final Operator[] OPERATORS = new Operator[]{NEGATE, MINUS, PLUS, MULTIPLY, DIVIDE, EXPONENT, MODULO};
    private static final Operator[] OPERATORS_EXCEL = new Operator[]{NEGATE_HIGH, MINUS, PLUS, MULTIPLY, DIVIDE, EXPONENT, MODULO};
    private static final Function[] FUNCTIONS = new Function[]{SINE, COSINE, TANGENT, ASINE, ACOSINE, ATAN, SINEH, COSINEH, TANGENTH, MIN, MAX, SUM, AVERAGE, LN, LOG, ROUND, CEIL, FLOOR, ABS, RANDOM};
    private static final Constant[] CONSTANTS = new Constant[]{PI, E};
    private static Parameters DEFAULT_PARAMETERS;
    private static final NumberFormat FORMATTER;

    public static Parameters getDefaultParameters() {
        return DoubleEvaluator.getDefaultParameters(Style.STANDARD);
    }

    public static Parameters getDefaultParameters(Style style) {
        Parameters result = new Parameters();
        result.addOperators(style == Style.STANDARD ? Arrays.asList(OPERATORS) : Arrays.asList(OPERATORS_EXCEL));
        result.addFunctions(Arrays.asList(FUNCTIONS));
        result.addConstants(Arrays.asList(CONSTANTS));
        result.addFunctionBracket(BracketPair.PARENTHESES);
        result.addExpressionBracket(BracketPair.PARENTHESES);
        return result;
    }

    private static Parameters getParameters() {
        if (DEFAULT_PARAMETERS == null) {
            DEFAULT_PARAMETERS = DoubleEvaluator.getDefaultParameters();
        }
        return DEFAULT_PARAMETERS;
    }

    public DoubleEvaluator() {
        this(DoubleEvaluator.getParameters());
    }

    public DoubleEvaluator(Parameters parameters) {
        super(parameters);
    }

    @Override
    protected Double toValue(String literal, Object evaluationContext) {
        ParsePosition p = new ParsePosition(0);
        Number result = FORMATTER.parse(literal, p);
        if (p.getIndex() == 0 || p.getIndex() != literal.length()) {
            throw new IllegalArgumentException(literal + " is not a number");
        }
        return result.doubleValue();
    }

    @Override
    protected Double evaluate(Constant constant, Object evaluationContext) {
        if (constant == PI) {
            return Math.PI;
        }
        if (constant == E) {
            return Math.E;
        }
        return (Double)super.evaluate(constant, evaluationContext);
    }

    @Override
    protected Double evaluate(Operator operator, Iterator<Double> operands, Object evaluationContext) {
        if (operator == NEGATE || operator == NEGATE_HIGH) {
            return -operands.next().doubleValue();
        }
        if (operator == MINUS) {
            return operands.next() - operands.next();
        }
        if (operator == PLUS) {
            return operands.next() + operands.next();
        }
        if (operator == MULTIPLY) {
            return operands.next() * operands.next();
        }
        if (operator == DIVIDE) {
            return operands.next() / operands.next();
        }
        if (operator == EXPONENT) {
            return Math.pow(operands.next(), operands.next());
        }
        if (operator == MODULO) {
            return operands.next() % operands.next();
        }
        return super.evaluate(operator, operands, evaluationContext);
    }

    @Override
    protected Double evaluate(Function function, Iterator<Double> arguments, Object evaluationContext) {
        Double result;
        if (function == ABS) {
            result = Math.abs(arguments.next());
        } else if (function == CEIL) {
            result = Math.ceil(arguments.next());
        } else if (function == FLOOR) {
            result = Math.floor(arguments.next());
        } else if (function == ROUND) {
            Double arg = arguments.next();
            result = arg == Double.NEGATIVE_INFINITY || arg == Double.POSITIVE_INFINITY ? arg : Double.valueOf(Math.round(arg));
        } else if (function == SINEH) {
            result = Math.sinh(arguments.next());
        } else if (function == COSINEH) {
            result = Math.cosh(arguments.next());
        } else if (function == TANGENTH) {
            result = Math.tanh(arguments.next());
        } else if (function == SINE) {
            result = Math.sin(arguments.next());
        } else if (function == COSINE) {
            result = Math.cos(arguments.next());
        } else if (function == TANGENT) {
            result = Math.tan(arguments.next());
        } else if (function == ACOSINE) {
            result = Math.acos(arguments.next());
        } else if (function == ASINE) {
            result = Math.asin(arguments.next());
        } else if (function == ATAN) {
            result = Math.atan(arguments.next());
        } else if (function == MIN) {
            result = arguments.next();
            while (arguments.hasNext()) {
                result = Math.min(result, arguments.next());
            }
        } else if (function == MAX) {
            result = arguments.next();
            while (arguments.hasNext()) {
                result = Math.max(result, arguments.next());
            }
        } else if (function == SUM) {
            result = 0.0;
            while (arguments.hasNext()) {
                result = result + arguments.next();
            }
        } else if (function == AVERAGE) {
            result = 0.0;
            int nb = 0;
            while (arguments.hasNext()) {
                result = result + arguments.next();
                ++nb;
            }
            result = result / (double)nb;
        } else {
            result = function == LN ? Double.valueOf(Math.log(arguments.next())) : (function == LOG ? Double.valueOf(Math.log10(arguments.next())) : (function == RANDOM ? Double.valueOf(Math.random()) : super.evaluate(function, arguments, evaluationContext)));
        }
        this.errIfNaN(result, function);
        return result;
    }

    private void errIfNaN(Double result, Function function) {
        if (result.equals(Double.NaN)) {
            throw new IllegalArgumentException("Invalid argument passed to " + function.getName());
        }
    }

    static {
        FORMATTER = NumberFormat.getNumberInstance(Locale.US);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        STANDARD,
        EXCEL;

    }
}

