/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;

public class ExperienceCommand
extends AbstractCommand {
    public static int getTotalExperience(Player p) {
        return ExperienceCommand.getTotalExperience(p.getLevel(), p.getExp());
    }

    public static int getTotalExperience(int level, double bar) {
        return ExperienceCommand.getTotalExpToLevel(level) + (int)((double)ExperienceCommand.getExpToLevel(level + 1) * bar);
    }

    public static int getExpToLevel(int level) {
        if (level < 16) {
            return 17;
        }
        if (level < 31) {
            return 3 * level - 31;
        }
        return 7 * level - 155;
    }

    public static int getTotalExpToLevel(int level) {
        if (level < 16) {
            return 17 * level;
        }
        if (level < 31) {
            return (int)(1.5 * (double)level * (double)level - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * (double)level * (double)level - 151.5 * (double)level + 2220.0);
    }

    public static void setTotalExperience(Player player, int exp) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        if (exp > 0) {
            player.giveExp(exp);
        }
    }

    public static void setLevel(Player player, int level) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        if (level > 0) {
            player.giveExp(ExperienceCommand.getExpToLevel(level));
        }
    }

    public static void giveExperience(Player player, int exp) {
        int currentExp = ExperienceCommand.getTotalExperience(player);
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        int newexp = currentExp + exp;
        if (newexp > 0) {
            player.giveExp(newexp);
        }
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int amount = 0;
        Type type = Type.SET;
        boolean level = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(arg) || aH.matchesInteger(arg)) {
                amount = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesArg("SET, GIVE, TAKE", arg)) {
                type = Type.valueOf(arg.toUpperCase());
                continue;
            }
            if (aH.matchesArg("LEVEL", arg)) {
                level = true;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("quantity", amount).addObject("type", (Object)type).addObject("level", level);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Integer quantity = (Integer)scriptEntry.getObject("quantity");
        Boolean level = (Boolean)scriptEntry.getObject("level");
        dB.report(this.name, aH.debugObj("Type", type.toString()) + aH.debugObj("Quantity", level != false ? quantity.toString() + " levels" : quantity.toString()) + aH.debugObj("Player", scriptEntry.getPlayer().getName()));
        Player player = scriptEntry.getPlayer().getPlayerEntity();
        switch (type) {
            case SET: {
                if (level.booleanValue()) {
                    ExperienceCommand.setLevel(player, quantity);
                    break;
                }
                ExperienceCommand.setTotalExperience(player, quantity);
                break;
            }
            case GIVE: {
                if (level.booleanValue()) {
                    ExperienceCommand.setLevel(player, player.getLevel() + quantity);
                    break;
                }
                ExperienceCommand.giveExperience(player, quantity);
                break;
            }
            case TAKE: {
                if (level.booleanValue()) {
                    ExperienceCommand.setLevel(player, player.getLevel() - quantity);
                    break;
                }
                ExperienceCommand.giveExperience(player, -quantity.intValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SET,
        GIVE,
        TAKE;

    }
}

