/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ContextTags
implements Listener {
    public ContextTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void scriptTags(ReplaceableTagEvent event) {
        if (!event.matches("script, s") || event.getScriptEntry() == null) {
            return;
        }
        ScriptContainer script = event.getScriptEntry().getScript().getContainer();
        String type = event.getType();
        String sub_type = "";
        if (event.hasSubType()) {
            sub_type = event.getSubType();
        }
        String specifier = "";
        if (event.hasSpecifier()) {
            specifier = event.getSpecifier();
        }
        if (event.hasTypeContext()) {
            script = ScriptRegistry.getScriptContainer(event.getTypeContext());
        }
        if (type.equalsIgnoreCase("REQUIREMENTS")) {
            if (sub_type.equalsIgnoreCase("CHECK")) {
                event.setReplaced(String.valueOf(event.getScriptEntry().getScript().getContainer().checkBaseRequirements(event.getPlayer(), event.getNPC())));
            }
        } else if (type.equalsIgnoreCase("TYPE")) {
            event.setReplaced(script.getType());
        } else if (type.equalsIgnoreCase("SPEED")) {
            if (script.contains("SPEED")) {
                event.setReplaced(script.getString("SPEED"));
            }
        } else if (type.equalsIgnoreCase("NAME")) {
            event.setReplaced(script.getName());
        }
    }

    @EventHandler
    public void contextTags(ReplaceableTagEvent event) {
        if (!event.matches("context, c") || event.getScriptEntry() == null) {
            return;
        }
        String type = event.getType();
        if (event.getScriptEntry().getResidingQueue().hasContext(type)) {
            Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
            event.setReplaced(event.getScriptEntry().getResidingQueue().getContext(type).getAttribute(attribute.fulfill(2)));
        }
        if (!ScriptRegistry.containsScript(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class)) {
            return;
        }
        TaskScriptContainer script = ScriptRegistry.getScriptContainerAs(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class);
        ScriptEntry entry = event.getScriptEntry();
        if (entry.hasObject("CONTEXT")) {
            Map<String, Integer> id;
            HashMap context = (HashMap)entry.getObject("CONTEXT");
            if (context.containsKey(String.valueOf((id = script.getContextMap()).get(type.toUpperCase())))) {
                event.setReplaced((String)context.get(String.valueOf(id.get(type.toUpperCase()))));
            }
        } else {
            event.setReplaced("null");
        }
    }

    @EventHandler
    public void savedEntryTags(ReplaceableTagEvent event) {
        if (!event.matches("entry, e") || event.getScriptEntry() == null) {
            return;
        }
        if (event.getScriptEntry().getResidingQueue() != null && event.getScriptEntry().getResidingQueue().getHeldScriptEntry(event.getNameContext()) != null) {
            String id = event.getNameContext();
            Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
            ScriptEntry held = event.getScriptEntry().getResidingQueue().getHeldScriptEntry(id);
            if (held == null) {
                dB.echoError("Bad saved entry ID " + id);
            } else if (!held.hasObject(attribute.getAttribute(2)) || held.getdObject(attribute.getAttribute(2)) == null) {
                dB.echoError("Bad saved entry object " + attribute.getAttribute(2));
            } else {
                event.setReplaced(held.getdObject(attribute.getAttribute(2)).getAttribute(attribute.fulfill(2)));
            }
        } else {
            event.setReplaced("null");
        }
    }
}

