/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets.handler;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.StreamSerializer;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.objects.dItem;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InvisibleLoreHandler {
    public Denizen denizen;
    public ProtocolManager protocolManager;

    public InvisibleLoreHandler(Denizen denizen) {
        this.denizen = denizen;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.registerListeners();
    }

    public void registerListeners() {
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.denizen, ConnectionSide.SERVER_SIDE, ListenerPriority.HIGH, new Integer[]{103, 104}){

            public void onPacketSending(PacketEvent event) {
                PacketContainer packet = event.getPacket();
                try {
                    switch (packet.getID()) {
                        case 103: {
                            StructureModifier sm = packet.getItemModifier();
                            for (int i = 0; i < sm.size(); ++i) {
                                InvisibleLoreHandler.this.encodeLore((ItemStack)sm.read(i));
                            }
                            break;
                        }
                        case 104: {
                            StructureModifier smArray = packet.getItemArrayModifier();
                            for (int i = 0; i < smArray.size(); ++i) {
                                InvisibleLoreHandler.this.encodeLore((ItemStack[])smArray.read(i));
                            }
                            break;
                        }
                    }
                }
                catch (FieldAccessException fieldAccessException) {
                    // empty catch block
                }
            }
        });
        PacketAdapter.AdapterParameteters params = PacketAdapter.params().plugin((Plugin)this.denizen).connectionSide(ConnectionSide.BOTH).listenerPriority(ListenerPriority.HIGH).options(new ListenerOptions[]{ListenerOptions.INTERCEPT_INPUT_BUFFER}).packets(new Integer[]{107});
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(params){

            public void onPacketSending(PacketEvent event) {
                if (event.getPacketID() == 107) {
                    InvisibleLoreHandler.this.encodeLore((ItemStack)event.getPacket().getItemModifier().read(0));
                }
            }

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPacketID() == 107) {
                    DataInputStream input = event.getNetworkMarker().getInputStream();
                    if (input == null) {
                        return;
                    }
                    try {
                        input.readShort();
                        ItemStack stack = InvisibleLoreHandler.this.readItemStack(input, new StreamSerializer());
                        stack = InvisibleLoreHandler.this.decodeLore(stack);
                        event.getPacket().getItemModifier().write(0, (Object)stack);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ItemStack decodeLore(ItemStack stack) {
        if (stack != null) {
            NbtCompound tag;
            if (!MinecraftReflection.isCraftItemStack((Object)stack)) {
                stack = MinecraftReflection.getBukkitItemStack((ItemStack)stack);
            }
            if ((tag = NbtFactory.asCompound((NbtBase)NbtFactory.fromItemTag((ItemStack)stack))).containsKey("dItem")) {
                ItemMeta meta = stack.getItemMeta();
                LinkedList<String> lore = new LinkedList<String>();
                for (String line : meta.getLore()) {
                    if (line.startsWith("\u00a70id:")) continue;
                    lore.add(line);
                }
                NbtList dataList = tag.getList("dItem");
                dataList.setElementType(NbtType.TAG_STRING);
                Iterator it = dataList.iterator();
                while (it.hasNext()) {
                    lore.add((String)it.next());
                }
                meta.setLore(lore);
                stack.setItemMeta(meta);
            }
        }
        return stack;
    }

    public ItemStack[] encodeLore(ItemStack[] stacks) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            stacks[i] = this.encodeLore(stacks[i]);
        }
        return stacks;
    }

    public ItemStack encodeLore(ItemStack stack) {
        if (stack != null) {
            dItem item;
            if (stack.hasItemMeta() && stack.getItemMeta().hasLore() && (item = new dItem(stack)).containsLore("\u00a70id:")) {
                if (!MinecraftReflection.isCraftItemStack((Object)stack)) {
                    stack = MinecraftReflection.getBukkitItemStack((ItemStack)stack);
                }
                ItemMeta meta = stack.getItemMeta();
                List lore = meta.getLore();
                LinkedList<String> data = new LinkedList<String>();
                LinkedList<String> newLore = new LinkedList<String>();
                for (String line : lore) {
                    if (line.startsWith("\u00a70id:")) {
                        data.add(line);
                        continue;
                    }
                    newLore.add(line);
                }
                meta.setLore(newLore);
                stack.setItemMeta(meta);
                NbtCompound tag = NbtFactory.asCompound((NbtBase)NbtFactory.fromItemTag((ItemStack)stack));
                tag.put("dItem", (NbtBase)NbtFactory.ofList((String)"dItem", data));
            }
            return stack;
        }
        return null;
    }

    private ItemStack readItemStack(DataInputStream input, StreamSerializer serializer) throws IOException {
        ItemStack result = null;
        short type = input.readShort();
        if (type >= 0) {
            byte amount = input.readByte();
            short damage = input.readShort();
            result = new ItemStack((int)type, (int)amount, damage);
            NbtCompound tag = serializer.deserializeCompound(input);
            if (tag != null) {
                result = MinecraftReflection.getBukkitItemStack((ItemStack)result);
                NbtFactory.setItemTag((ItemStack)result, (NbtCompound)tag);
            }
        }
        return result;
    }
}

