/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListenerInstance
extends AbstractListener
implements Listener {
    ItemType type = null;
    dList items;
    int required = 0;
    int items_so_far = 0;
    String region = null;
    dCuboid cuboid = null;

    @Override
    public void onBuild(List<aH.Argument> args) {
        for (aH.Argument arg : args) {
            if (arg.matchesEnum(ItemType.values()) && this.type == null) {
                this.type = ItemType.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (arg.matchesPrefix("qty, q") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                this.required = aH.getIntegerFrom(arg.getValue());
                continue;
            }
            if (arg.matchesPrefix("items, item, i, name, names")) {
                this.items = (dList)arg.asType(dList.class);
                continue;
            }
            if (arg.matchesPrefix("region, r")) {
                this.region = arg.getValue();
                continue;
            }
            if (!arg.matchesPrefix("cuboid, c") || !arg.matchesArgumentType(dCuboid.class)) continue;
            this.cuboid = (dCuboid)arg.asType(dCuboid.class);
        }
        if (this.items == null) {
            this.items = new dList("*");
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: CRAFT, SMELT, FISH");
            this.cancel();
        }
    }

    public void increment(String object, int amount) {
        this.items_so_far += amount;
        dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " " + this.type.toString().toLowerCase() + "ed " + amount + " " + object + ".");
        this.check();
    }

    @EventHandler
    public void listenItem(InventoryClickEvent event) {
        if (event.getSlotType().toString().equals("RESULT") && event.getWhoClicked() == this.player.getPlayerEntity()) {
            if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getLocation(), this.region)) {
                return;
            }
            if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
                return;
            }
            String inventoryType = event.getInventory().getType().toString();
            if (this.type == ItemType.CRAFT && (inventoryType.equals("CRAFTING") || inventoryType.equals("WORKBENCH")) || this.type == ItemType.SMELT && inventoryType.equals("FURNACE")) {
                final ItemStack item = new ItemStack(event.getCurrentItem());
                if (!(this.items.contains(item.getType().name().toLowerCase()) || this.items.contains(item.getTypeId()) || this.items.contains("*"))) {
                    return;
                }
                if (event.isShiftClick()) {
                    final int initialQty = new dInventory((Inventory)this.player.getPlayerEntity().getInventory()).count(item, false);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                        public void run() {
                            int newQty = new dInventory((Inventory)ItemListenerInstance.this.player.getPlayerEntity().getInventory()).count(item, false);
                            int difference = newQty - initialQty;
                            if (difference > 0) {
                                ItemListenerInstance.this.increment(item.getType().toString(), difference);
                            }
                        }
                    }, 1L);
                } else {
                    this.increment(item.getType().toString(), item.getAmount());
                }
            }
        }
    }

    @EventHandler
    public void listenFish(PlayerFishEvent event) {
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getLocation(), this.region)) {
            return;
        }
        if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
            return;
        }
        if (event.getState().toString().equals("CAUGHT_FISH")) {
            this.increment("FISH", 1);
        }
    }

    @Override
    public void onSave() {
        try {
            this.store("Type", this.type.name());
            this.store("Items", this.items);
            this.store("Quantity Needed", this.required);
            this.store("Quantity Done", this.items_so_far);
            this.store("Region", this.region);
            if (this.cuboid != null) {
                this.store("Cuboid", this.cuboid.identify());
            }
        }
        catch (Exception e) {
            dB.echoError("Unable to save ITEM listener for '%s'!", this.player.getName());
        }
    }

    @Override
    public void onLoad() {
        try {
            this.type = ItemType.valueOf((String)this.get("Type"));
            this.items = new dList((List)this.get("Items"));
            this.required = (Integer)this.get("Quantity Needed");
            this.items_so_far = (Integer)this.get("Quantity Done");
            this.region = (String)this.get("Region");
            this.cuboid = dCuboid.valueOf((String)this.get("Cuboid"));
        }
        catch (Exception e) {
            dB.echoError("Unable to load ITEM listener for '%s'!", this.player.getName());
            this.cancel();
        }
    }

    @Override
    public void onFinish() {
    }

    public void check() {
        if (this.items_so_far >= this.required) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            PlayerFishEvent.getHandlerList().unregister((Listener)this);
            this.finish();
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public String report() {
        return this.player.getName() + " current has quest listener '" + this.id + "' active and must " + this.type.name() + " " + Arrays.toString(this.items.toArray()) + " '(s). Current progress '" + this.items_so_far + "/" + this.required + "'.";
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemType {
        CRAFT,
        SMELT,
        FISH;

    }
}

