/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.ArrayList;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_6_R2.Entity;
import net.minecraft.server.v1_6_R2.EntityFishingHook;
import net.minecraft.server.v1_6_R2.EntityHuman;
import net.minecraft.server.v1_6_R2.EntityItem;
import net.minecraft.server.v1_6_R2.Item;
import net.minecraft.server.v1_6_R2.ItemStack;
import net.minecraft.server.v1_6_R2.MathHelper;
import net.minecraft.server.v1_6_R2.World;
import net.minecraft.server.v1_6_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_6_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.util.Vector;

public class FishingTrait
extends Trait {
    @Persist(value="fishing")
    private boolean fishing = false;
    @Persist(value="catch fish")
    private boolean catchFish = false;
    @Persist(value="fishing spot")
    private Location fishingLocation = null;
    ArrayList<Location> available = new ArrayList();
    EntityHuman eh = null;
    WorldServer nmsworld = null;
    Location fishingSpot = null;
    EntityFishingHook fishHook = null;
    EntityItem fish = null;
    @Persist(value="catch chance")
    int catchPercent = 65;
    int reelCount = 100;
    int castCount = 0;

    public void run() {
        ++this.reelCount;
        ++this.castCount;
        if (this.fish != null && this.fish.getBukkitEntity().getLocation().distance(this.npc.getBukkitEntity().getLocation()) < 3.0) {
            try {
                this.fish.getBukkitEntity().remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.reelCount == 400) {
            this.reel();
            this.reelCount = 0;
            this.castCount = 325;
        }
        if (this.castCount == 400) {
            this.cast();
            this.castCount = 0;
        }
    }

    public void onSpawn() {
        this.eh = ((CraftPlayer)this.npc.getBukkitEntity()).getHandle();
        this.nmsworld = ((CraftWorld)this.npc.getBukkitEntity().getWorld()).getHandle();
    }

    public void startFishing(Location location) {
        DenizenAPI.getDenizenNPC(this.npc).action("start fishing", null);
        this.fishingLocation = location.clone();
        this.cast();
        this.fishing = true;
    }

    public void stopFishing() {
        DenizenAPI.getDenizenNPC(this.npc).action("stop fishing", null);
        this.reel();
        this.fishingLocation = null;
        this.fishing = false;
    }

    public void startFishing() {
        this.fishing = true;
        this.fishingLocation = this.npc.getBukkitEntity().getLocation();
    }

    private void cast() {
        DenizenAPI.getDenizenNPC(this.npc).action("cast fishing rod", null);
        if (this.fishingLocation == null) {
            dB.echoError("Fishing location not found!");
            return;
        }
        double v = 34.0;
        double g = 20.0;
        Location from = null;
        Location to = null;
        this.fishHook = new EntityFishingHook((World)this.nmsworld, this.eh);
        this.nmsworld.addEntity((Entity)this.fishHook);
        from = this.npc.getBukkitEntity().getLocation();
        from = from.add(0.0, 0.33, 0.0);
        to = this.fishingLocation;
        Vector test = to.clone().subtract(from).toVector();
        Double elev = test.getY();
        Double testAngle = FishingTrait.launchAngle(from, to, v, elev, g);
        if (testAngle == null) {
            return;
        }
        Double hangtime = FishingTrait.hangtime(testAngle, v, elev, g);
        Vector victor = to.clone().subtract(from).toVector();
        Double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        elev = victor.getY();
        if (dist == 0.0) {
            return;
        }
        Double launchAngle = FishingTrait.launchAngle(from, to, v, elev, g);
        if (launchAngle == null) {
            return;
        }
        victor.setY(Math.tan(launchAngle) * dist);
        victor = FishingTrait.normalizeVector(victor);
        v += 0.5 * Math.pow(hangtime, 2.0);
        victor = victor.multiply((v += (Utilities.getRandom().nextDouble() - 0.8) / 2.0) / 20.0);
        Projectile theHook = (Projectile)this.fishHook.getBukkitEntity();
        theHook.setShooter(this.npc.getBukkitEntity());
        theHook.setVelocity(victor);
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
    }

    private void reel() {
        DenizenAPI.getDenizenNPC(this.npc).action("reel in fishing rod", null);
        int chance = (int)(Math.random() * 100.0);
        try {
            this.fishHook.getBukkitEntity().remove();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (chance > this.catchPercent && this.fishHook != null && this.catchFish) {
            try {
                this.fish.getBukkitEntity().remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fish = new EntityItem((World)this.nmsworld, this.fishHook.locX, this.fishHook.locY, this.fishHook.locZ, new ItemStack(Item.RAW_FISH));
            double d5 = this.npc.getBukkitEntity().getLocation().getX() - this.fishHook.locX;
            double d6 = this.npc.getBukkitEntity().getLocation().getY() - this.fishHook.locY;
            double d7 = this.npc.getBukkitEntity().getLocation().getZ() - this.fishHook.locZ;
            double d8 = MathHelper.sqrt((double)(d5 * d5 + d6 * d6 + d7 * d7));
            double d9 = 0.1;
            this.fish.motX = d5 * d9;
            this.fish.motY = d6 * d9 + (double)MathHelper.sqrt((double)d8) * 0.08;
            this.fish.motZ = d7 * d9;
            this.nmsworld.addEntity((Entity)this.fish);
            DenizenAPI.getDenizenNPC(this.npc).action("catch fish", null);
        }
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
    }

    public boolean isFishing() {
        return this.fishing;
    }

    public Location getFishingLocation() {
        return this.fishingLocation;
    }

    public FishingTrait() {
        super("fishing");
    }

    public static Double launchAngle(Location from, Location to, double v, double elev, double g) {
        double derp;
        Vector victor = from.clone().subtract(to).toVector();
        Double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        if (v4 < (derp = g * (g * Math.pow(dist, 2.0) + 2.0 * elev * v2))) {
            return null;
        }
        return Math.atan((v2 - Math.sqrt(v4 - derp)) / (g * dist));
    }

    public static double hangtime(double launchAngle, double v, double elev, double g) {
        double a = v * Math.sin(launchAngle);
        double b = -2.0 * g * elev;
        if (Math.pow(a, 2.0) + b < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(Math.pow(a, 2.0) + b)) / g;
    }

    public static Vector normalizeVector(Vector victor) {
        double mag = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getY(), 2.0) + Math.pow(victor.getZ(), 2.0));
        if (mag != 0.0) {
            return victor.multiply(1.0 / mag);
        }
        return victor.multiply(0);
    }

    public void setCatchFish(Boolean catchFish) {
        this.catchFish = catchFish;
    }

    public void setCatchPercent(int catchPercent) {
        this.catchPercent = catchPercent;
    }
}

