/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class RunCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("i, id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("a, as") && arg.matchesArgumentType(dPlayer.class)) {
                scriptEntry.setPlayer((dPlayer)arg.asType(dPlayer.class));
                continue;
            }
            if (arg.matchesPrefix("a, as") && arg.matchesArgumentType(dNPC.class)) {
                scriptEntry.setNPC((dNPC)arg.asType(dNPC.class));
                continue;
            }
            if (arg.matchesPrefix("a, as")) {
                dB.echoDebug("Specified target was not attached. Value must contain a valid PLAYER or NPC object.");
                continue;
            }
            if (arg.matchesPrefix("d, def, define, c, context")) {
                scriptEntry.addObject("definitions", arg.asType(dList.class));
                continue;
            }
            if (arg.matches("instant, instantly")) {
                scriptEntry.addObject("instant", new Element(true));
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("delay", arg.asType(Duration.class));
                continue;
            }
            if (arg.matches("local, locally")) {
                scriptEntry.addObject("local", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (scriptEntry.hasObject("path")) continue;
            scriptEntry.addObject("path", arg.asElement());
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.report(this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getdObject("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getdObject("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : "") + (scriptEntry.hasObject("delay") ? scriptEntry.getdObject("delay").debug() : ""));
        dScript script = (dScript)scriptEntry.getObject("script");
        List<ScriptEntry> entries = scriptEntry.hasObject("local") ? scriptEntry.getScript().getContainer().getEntries(scriptEntry.getPlayer(), scriptEntry.getNPC(), scriptEntry.getElement("path").asString()) : (scriptEntry.hasObject("path") && scriptEntry.getObject("path") != null ? script.getContainer().getEntries(scriptEntry.getPlayer(), scriptEntry.getNPC(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.getPlayer(), scriptEntry.getNPC()));
        String id = scriptEntry.hasObject("id") ? scriptEntry.getElement("id").asString() : ScriptQueue._getNextId();
        ScriptQueue queue = scriptEntry.hasObject("instant") ? InstantQueue.getQueue(id).addEntries(entries) : TimedQueue.getQueue(id).addEntries(entries);
        if (scriptEntry.hasObject("delay")) {
            queue.delayUntil(System.currentTimeMillis() + ((Duration)scriptEntry.getObject("delay")).getMillis());
        }
        if (scriptEntry.hasObject("definitions")) {
            int x = 1;
            dList definitions = (dList)scriptEntry.getObject("definitions");
            String[] definition_names = null;
            try {
                definition_names = script.getContainer().getString("definitions").split("\\|");
            }
            catch (Exception e) {
                // empty catch block
            }
            for (String definition : definitions) {
                queue.addDefinition(definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x), definition);
                ++x;
            }
        }
        queue.start();
    }
}

