/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_6_R3.Entity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_6_R3.entity.CraftEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Rotation {
    public static void rotate(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
            return;
        }
        if (entity instanceof LivingEntity) {
            NMS.look((LivingEntity)((LivingEntity)entity), (float)yaw, (float)pitch);
        } else {
            Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    public static void faceLocation(org.bukkit.entity.Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location loc = from.getLocation();
        double xDiff = at.getX() - loc.getX();
        double yDiff = at.getY() - loc.getY();
        double zDiff = at.getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
        double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        Rotation.rotate(from, (float)yaw - 90.0f, (float)pitch);
    }

    public static void faceEntity(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity target) {
        Rotation.faceLocation(entity, target.getLocation());
    }

    public static boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = Rotation.normalizeYaw(from.getYaw());
        double requiredYaw = Rotation.normalizeYaw(Rotation.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    public static boolean isFacingLocation(org.bukkit.entity.Entity from, Location at, float degreeLimit) {
        return Rotation.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    public static boolean isFacingEntity(org.bukkit.entity.Entity from, org.bukkit.entity.Entity at, float degreeLimit) {
        return Rotation.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    public static double normalizeYaw(double yaw) {
        if ((yaw = (yaw - 90.0) % 360.0) < 0.0) {
            yaw += 360.0;
        }
        return yaw;
    }

    public static float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    public static String getCardinal(double yaw) {
        if (0.0 <= (yaw = Rotation.normalizeYaw(yaw)) && yaw < 22.5) {
            return "west";
        }
        if (22.5 <= yaw && yaw < 67.5) {
            return "northwest";
        }
        if (67.5 <= yaw && yaw < 112.5) {
            return "north";
        }
        if (112.5 <= yaw && yaw < 157.5) {
            return "northeast";
        }
        if (157.5 <= yaw && yaw < 202.5) {
            return "east";
        }
        if (202.5 <= yaw && yaw < 247.5) {
            return "southeast";
        }
        if (247.5 <= yaw && yaw < 292.5) {
            return "south";
        }
        if (292.5 <= yaw && yaw < 337.5) {
            return "southwest";
        }
        if (337.5 <= yaw && yaw < 360.0) {
            return "west";
        }
        return null;
    }
}

