/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerTags
implements Listener {
    public static Map<String, List<String>> playerChatHistory = new ConcurrentHashMap<String, List<String>>(8, 0.9f, 2);

    public PlayerTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void addMessage(AsyncPlayerChatEvent event) {
        List<String> history = playerChatHistory.get(event.getPlayer().getName());
        if (history == null) {
            history = new ArrayList<String>();
        }
        if (history.size() > 10) {
            history.remove(9);
        }
        history.add(0, event.getMessage());
        playerChatHistory.put(event.getPlayer().getName(), history);
    }

    @EventHandler
    public void playerTags(ReplaceableTagEvent event) {
        if (!event.matches("player, pl") || event.replaced()) {
            return;
        }
        Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
        dPlayer p = event.getPlayer();
        if (attribute.hasContext(1)) {
            if (dPlayer.matches(attribute.getContext(1))) {
                p = dPlayer.valueOf(attribute.getContext(1));
            } else {
                dB.echoDebug("Could not match '" + attribute.getContext(1) + "' to a valid player!");
                return;
            }
        }
        if (p == null || !p.isValid()) {
            dB.echoDebug("Invalid or missing player for tag <" + event.raw_tag + ">!");
            event.setReplaced("null");
            return;
        }
        event.setReplaced(p.getAttribute(attribute.fulfill(1)));
    }
}

