/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.utilities.DenizenAPI;

public class Settings {
    public static boolean ShowDebug() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Show", false);
    }

    public static int ConsoleWidth() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Debug.Console width", 60);
    }

    public static String ScriptQueueSpeed() {
        String delay = DenizenAPI.getCurrentInstance().getConfig().getString("Scripts.Queue speed", "0.5s");
        try {
            if (Double.valueOf(delay) < 1.0) {
                delay = "1t";
            }
        }
        catch (Exception e) {
            delay = "0.5s";
        }
        return delay;
    }

    public static boolean LoadScriptsInSubfolders() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Scripts.Load scripts in subfolders", true);
    }

    public static boolean HealthTraitEnabledByDefault() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Enabled", false);
    }

    public static boolean HealthTraitRespawnEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Respawn.Enabled", true);
    }

    public static boolean HealthTraitAnimatedDeathEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Animated death.Enabled", true);
    }

    public static String HealthTraitRespawnDelay() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Traits.Health.Respawn.Delay", "10s");
    }

    public static boolean TriggerEnabled(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Enabled", true);
    }

    public static double TriggerDefaultCooldown(String triggerName) {
        return Duration.valueOf(DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Cooldown", "5s")).getSeconds();
    }

    public static double TriggerDefaultRange(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Range", -1.0);
    }

    public static String TriggerDefaultCooldownType(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Cooldown Type", "Player");
    }

    public static boolean ClickTriggerAllowsLeftClick() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Click.Allows left click", false);
    }

    public static String EngageTimeoutInSeconds() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Engage.Timeout", "150s");
    }

    public static boolean ChatAsynchronous() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Use asynchronous event", true);
    }

    public static String ChatToNpcFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to NPC", "You -> <npc.name.nickname>: <text>");
    }

    public static String ChatToNpcOverheardFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to NPC overheard", "<player.name> -> <npc.name.nickname>: <text>");
    }

    public static double ChatToNpcOverhearingRange() {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers.Chat.Overhearing range", 4.0);
    }

    public static boolean ChatMustSeeNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must be able to see NPC", true);
    }

    public static boolean ChatMustLookAtNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must be looking in direction of NPC", true);
    }

    public static boolean ChatGloballyIfFailedChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears globally.If triggers failed", false);
    }

    public static boolean ChatGloballyIfNoChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears globally.If triggers missing", true);
    }

    public static boolean ChatGloballyIfUninteractable() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears globally.If NPC uninteractable", true);
    }

    public static boolean WorldScriptChatEventAsynchronous() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Scripts.World.Events.On player chats.Use asynchronous event", true);
    }

    public static Duration WorldScriptTimeEventFrequency() {
        return Duration.valueOf(DenizenAPI.getCurrentInstance().getConfig().getString("Scripts.World.Events.On time changes.Frequency of check", "250t"));
    }
}

