/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ScribeCommand
extends AbstractCommand
implements Listener {
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnum(BookAction.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)BookAction.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                scriptEntry.addObject("action", (Object)BookAction.DROP);
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentType(dItem.class)) {
                scriptEntry.addObject("item", arg.asType(dItem.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new Object[]{BookAction.GIVE});
        scriptEntry.defaultObject("item", new dItem(Material.WRITTEN_BOOK));
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Missing SCRIPT argument!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        BookAction action = (BookAction)((Object)scriptEntry.getObject("action"));
        dItem book = (dItem)scriptEntry.getObject("item");
        dScript script = (dScript)scriptEntry.getObject("script");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        BookScriptContainer bookScript = (BookScriptContainer)script.getContainer();
        book = bookScript.writeBookTo(book, scriptEntry.getPlayer(), scriptEntry.getNPC());
        switch (action) {
            case DROP: {
                this.dropBook(location, book.getItemStack());
                break;
            }
            case GIVE: {
                this.giveBook(scriptEntry.getPlayer().getPlayerEntity(), book.getItemStack());
                scriptEntry.getPlayer().getPlayerEntity().updateInventory();
                break;
            }
            case EQUIP: {
                this.equipBook(scriptEntry.getPlayer().getPlayerEntity(), book.getItemStack());
                scriptEntry.getPlayer().getPlayerEntity().updateInventory();
                break;
            }
        }
    }

    private void giveBook(Player player, ItemStack book) {
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (emptySpot != -1) {
            player.getInventory().addItem(new ItemStack[]{book});
        } else {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.echoDebug("Player's inventory is full, dropped book.");
        }
    }

    private void equipBook(Player player, ItemStack book) {
        ItemStack currItem = player.getItemInHand();
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (currItem == null || currItem.getType() == Material.AIR) {
            player.setItemInHand(book);
            return;
        }
        emptySpot = inv.firstEmpty();
        dB.echoDebug("emptySpot: " + emptySpot);
        if (emptySpot == -1) {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.echoDebug("Player's inventory is full, dropped book.");
        } else {
            inv.setItem(emptySpot, currItem);
            player.setItemInHand(book);
            dB.echoDebug("...added book to player hand, moved original item");
        }
    }

    private void dropBook(Location location, ItemStack book) {
        location.getWorld().dropItem(location, book);
    }

    @EventHandler
    public void paragraph(ReplaceableTagEvent e) {
        if (e.matches("P")) {
            e.setReplaced("\n \u00a7r \n");
        } else if (e.matches("N")) {
            e.setReplaced("\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BookAction {
        GIVE,
        DROP,
        EQUIP,
        NONE;

    }
}

