/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;

public class TraitCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("state") && arg.matchesPrefix("state, s") && arg.matchesEnum(Toggle.values())) {
                scriptEntry.addObject("state", new Element(arg.getValue().toUpperCase()));
                continue;
            }
            if (scriptEntry.hasObject("trait")) continue;
            scriptEntry.addObject("trait", new Element(arg.getValue()));
        }
        if (!scriptEntry.hasObject("trait")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "TRAIT");
        }
        if (!scriptEntry.hasNPC()) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.defaultObject("state", new Element("TOGGLE"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element toggle = scriptEntry.getElement("state");
        Element traitName = scriptEntry.getElement("trait");
        NPC npc = scriptEntry.getNPC().getCitizen();
        dB.report(this.getName(), traitName.debug() + toggle.debug() + scriptEntry.getNPC().debug());
        Class trait = CitizensAPI.getTraitFactory().getTraitClass(traitName.asString());
        if (trait == null) {
            dB.echoError("Trait not found: " + traitName.asString());
            return;
        }
        switch (Toggle.valueOf(toggle.asString())) {
            case TRUE: 
            case ON: {
                if (npc.hasTrait(trait)) {
                    dB.echoError("NPC already has trait '" + traitName.asString() + "'");
                    break;
                }
                npc.addTrait(trait);
                break;
            }
            case FALSE: 
            case OFF: {
                if (!npc.hasTrait(trait)) {
                    dB.echoError("NPC does not have trait '" + traitName.asString() + "'");
                    break;
                }
                npc.removeTrait(trait);
                break;
            }
            case TOGGLE: {
                if (npc.hasTrait(trait)) {
                    npc.removeTrait(trait);
                    break;
                }
                npc.addTrait(trait);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Toggle {
        TOGGLE,
        TRUE,
        FALSE,
        ON,
        OFF;

    }
}

