/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.trait.Toggleable;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InvisibleTrait
extends Trait
implements Listener,
Toggleable {
    @Persist(value="")
    private boolean invisible = false;
    PotionEffect invis = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1);

    public InvisibleTrait() {
        super("invisible");
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        if (invisible) {
            this.setInvisible();
        } else if (this.npc.isSpawned() && this.npc.getBukkitEntity().hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            this.npc.getBukkitEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    private void setInvisible() {
        this.invis.apply(this.npc.getBukkitEntity());
    }

    public void onSpawn() {
        if (this.invisible) {
            this.setInvisible();
        }
    }

    public boolean toggle() {
        this.setInvisible(!this.invisible);
        return this.invisible;
    }
}

