/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_6_R3.CraftChunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class dChunk
extends CraftChunk
implements dObject {
    String prefix = "Chunk";

    @ObjectFetcher(value="ch")
    public static dChunk valueOf(String string) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = string.toLowerCase().replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new dChunk((CraftChunk)dWorld.valueOf(parts[2]).getWorld().getChunkAt(Integer.valueOf(parts[0]).intValue(), Integer.valueOf(parts[1]).intValue()));
            }
            catch (Exception e) {
                dB.log("valueOf dChunk returning null: ch@" + string);
                return null;
            }
        }
        dB.log("valueOf dChunk unable to handle malformed format: ch@" + string);
        return null;
    }

    public static boolean matches(String string) {
        return string.toLowerCase().startsWith("ch@");
    }

    public dChunk(CraftChunk chunk) {
        super(chunk.getHandle());
    }

    public dChunk(Location location) {
        super(((CraftChunk)location.getChunk()).getHandle());
    }

    public String getObjectType() {
        return "Chunk";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dChunk setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "ch@," + this.getX() + ',' + this.getZ() + ',' + this.getWorld().getName();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_loaded")) {
            return new Element(this.isLoaded()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("x")) {
            return new Element(this.getX()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new Element(this.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return dWorld.mirrorBukkitWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entities")) {
            dList entities = new dList();
            for (Entity ent : this.getEntities()) {
                entities.add(new dEntity(ent).identify());
            }
            return entities.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("living_entities")) {
            dList entities = new dList();
            for (Entity ent : this.getEntities()) {
                if (!(ent instanceof LivingEntity)) continue;
                entities.add(new dEntity(ent).identify());
            }
            return entities.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("height_map")) {
            ArrayList<String> height_map = new ArrayList<String>(this.getHandle().heightMap.length);
            for (int i : this.getHandle().heightMap) {
                height_map.add(String.valueOf(i));
            }
            return new dList((List<String>)height_map).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("average_height")) {
            int sum = 0;
            for (int i : this.getHandle().heightMap) {
                sum += i;
            }
            return new Element((double)sum / (double)this.getHandle().heightMap.length).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flat")) {
            int tolerance = attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1)) ? Integer.valueOf(attribute.getContext(1)) : 2;
            int x = this.getHandle().heightMap[0];
            for (int i : this.getHandle().heightMap) {
                if (Math.abs(x - i) <= tolerance) continue;
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            return Element.TRUE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("surface_blocks")) {
            dList surface_blocks = new dList();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    surface_blocks.add(new dLocation(this.getBlock(x, this.getChunkSnapshot().getHighestBlockYAt(x, z) - 1, z).getLocation()).identify());
                }
            }
            return surface_blocks.getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

