/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_6_R3.CraftChunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dWorld
implements dObject {
    static Map<String, dWorld> worlds = new HashMap<String, dWorld>();
    private String prefix;
    String world_name;

    public static dWorld mirrorBukkitWorld(World world) {
        if (world == null) {
            return null;
        }
        if (worlds.containsKey(world.getName())) {
            return worlds.get(world.getName());
        }
        return new dWorld(world);
    }

    @ObjectFetcher(value="w")
    public static dWorld valueOf(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            returnable = world;
        }
        if (returnable != null) {
            if (worlds.containsKey(returnable.getName())) {
                return worlds.get(returnable.getName());
            }
            return new dWorld(returnable);
        }
        dB.echoError("Invalid World! '" + string + "' could not be found.");
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(arg)) continue;
            returnable = world;
        }
        return returnable != null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public String getName() {
        return this.world_name;
    }

    public List<Entity> getEntities() {
        return this.getWorld().getEntities();
    }

    public dWorld(World world) {
        this(null, world);
    }

    public dWorld(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
        if (!worlds.containsKey(world.getName())) {
            worlds.put(world.getName(), this);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "World";
    }

    @Override
    public String identify() {
        return "w@" + this.world_name;
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entities")) {
            ArrayList<dEntity> entities = new ArrayList<dEntity>();
            for (Entity entity : this.getWorld().getEntities()) {
                entities.add(new dEntity(entity));
            }
            return new dList(entities).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("living_entities")) {
            ArrayList<dEntity> entities = new ArrayList<dEntity>();
            for (LivingEntity entity : this.getWorld().getLivingEntities()) {
                entities.add(new dEntity((Entity)entity));
            }
            return new dList(entities).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("players")) {
            ArrayList<dPlayer> players = new ArrayList<dPlayer>();
            for (Player player : this.getWorld().getPlayers()) {
                if (CitizensAPI.getNPCRegistry().isNPC((Entity)player)) continue;
                players.add(new dPlayer((OfflinePlayer)player));
            }
            return new dList(players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("random_loaded_chunk")) {
            int random = Utilities.getRandom().nextInt(this.getWorld().getLoadedChunks().length);
            return new dChunk((CraftChunk)this.getWorld().getLoadedChunks()[random]).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("loaded_chunks")) {
            dList chunks = new dList();
            for (Chunk ent : this.getWorld().getLoadedChunks()) {
                chunks.add(new dChunk((CraftChunk)ent).identify());
            }
            return chunks.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sea_level")) {
            return new Element(this.getWorld().getSeaLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawn_location")) {
            return new dLocation(this.getWorld().getSpawnLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.getWorld().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("seed")) {
            return new Element(this.getWorld().getSeed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("allows_animals")) {
            return new Element(this.getWorld().getAllowAnimals()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("allows_monsters")) {
            return new Element(this.getWorld().getAllowMonsters()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("allows_pvp")) {
            return new Element(this.getWorld().getPVP()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ambient_spawn_limit")) {
            return new Element(this.getWorld().getAmbientSpawnLimit()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("animal_spawn_limit")) {
            return new Element(this.getWorld().getAnimalSpawnLimit()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_generate_structures")) {
            return new Element(this.getWorld().canGenerateStructures()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("difficulty")) {
            return new Element(this.getWorld().getDifficulty().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_height")) {
            return new Element(this.getWorld().getMaxHeight()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("monster_spawn_limit")) {
            return new Element(this.getWorld().getMonsterSpawnLimit()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ticks_per_animal_spawn")) {
            return new Element(this.getWorld().getTicksPerAnimalSpawns()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ticks_per_monster_spawn")) {
            return new Element(this.getWorld().getTicksPerMonsterSpawns()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("water_animal_spawn_limit")) {
            return new Element(this.getWorld().getWaterAnimalSpawnLimit()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time.period")) {
            long time = this.getWorld().getTime();
            String period = time >= 23000L ? "dawn" : (time >= 13500L ? "night" : (time >= 12500L ? "dusk" : "day"));
            return new Element(period).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("time")) {
            return new Element(this.getWorld().getTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("moon_phase") || attribute.startsWith("moonphase")) {
            return new Element((int)(this.getWorld().getFullTime() / 24000L % 8L) + 1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_storm")) {
            return new Element(this.getWorld().hasStorm()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("weather_duration")) {
            return Duration.valueOf(this.getWorld().getWeatherDuration() + "t").getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

