/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;

public class dMaterial
implements dObject {
    static final Pattern materialPattern = Pattern.compile("(?:m@)?(\\w+)[,:]?(\\d+)?", 2);
    public static final dMaterial AIR = new dMaterial(Material.AIR);
    public static final dMaterial WHITE_WOOL = new dMaterial(Material.WOOL, 0).forceIdentifyAs("WHITE_WOOL");
    public static final dMaterial ORANGE_WOOL = new dMaterial(Material.WOOL, 1).forceIdentifyAs("ORANGE_WOOL");
    public static final dMaterial MAGENTA_WOOL = new dMaterial(Material.WOOL, 2).forceIdentifyAs("MAGENTA_WOOL");
    public static final dMaterial LIGHT_BLUE_WOOL = new dMaterial(Material.WOOL, 3).forceIdentifyAs("LIGHT_BLUE_WOOL");
    public static final dMaterial YELLOW_WOOL = new dMaterial(Material.WOOL, 4).forceIdentifyAs("YELLOW_WOOL");
    public static final dMaterial LIME_WOOL = new dMaterial(Material.WOOL, 5).forceIdentifyAs("LIME_WOOL");
    public static final dMaterial PINK_WOOL = new dMaterial(Material.WOOL, 6).forceIdentifyAs("PINK_WOOL");
    public static final dMaterial GRAY_WOOL = new dMaterial(Material.WOOL, 7).forceIdentifyAs("GRAY_WOOL");
    public static final dMaterial LIGHT_GRAY_WOOL = new dMaterial(Material.WOOL, 8).forceIdentifyAs("LIGHT_GRAY_WOOL");
    public static final dMaterial CYAN_WOOL = new dMaterial(Material.WOOL, 9).forceIdentifyAs("CYAN_WOOL");
    public static final dMaterial PURPLE_WOOL = new dMaterial(Material.WOOL, 10).forceIdentifyAs("PURPLE_WOOL");
    public static final dMaterial BLUE_WOOL = new dMaterial(Material.WOOL, 11).forceIdentifyAs("BLUE_WOOL");
    public static final dMaterial BROWN_WOOL = new dMaterial(Material.WOOL, 12).forceIdentifyAs("BROWN_WOOL");
    public static final dMaterial GREEN_WOOL = new dMaterial(Material.WOOL, 13).forceIdentifyAs("GREEN_WOOL");
    public static final dMaterial RED_WOOL = new dMaterial(Material.WOOL, 14).forceIdentifyAs("RED_WOOL");
    public static final dMaterial BLACK_WOOL = new dMaterial(Material.WOOL, 15).forceIdentifyAs("BLACK_WOOL");
    public static final dMaterial WHITE_CARPET = new dMaterial(Material.CARPET, 0).forceIdentifyAs("WHITE_CARPET");
    public static final dMaterial ORANGE_CARPET = new dMaterial(Material.CARPET, 1).forceIdentifyAs("ORANGE_CARPET");
    public static final dMaterial MAGENTA_CARPET = new dMaterial(Material.CARPET, 2).forceIdentifyAs("MAGENTA_CARPET");
    public static final dMaterial LIGHT_BLUE_CARPET = new dMaterial(Material.CARPET, 3).forceIdentifyAs("LIGHT_BLUE_CARPET");
    public static final dMaterial YELLOW_CARPET = new dMaterial(Material.CARPET, 4).forceIdentifyAs("YELLOW_CARPET");
    public static final dMaterial LIME_CARPET = new dMaterial(Material.CARPET, 5).forceIdentifyAs("LIME_CARPET");
    public static final dMaterial PINK_CARPET = new dMaterial(Material.CARPET, 6).forceIdentifyAs("PINK_CARPET");
    public static final dMaterial GRAY_CARPET = new dMaterial(Material.CARPET, 7).forceIdentifyAs("GRAY_CARPET");
    public static final dMaterial LIGHT_GRAY_CARPET = new dMaterial(Material.CARPET, 8).forceIdentifyAs("LIGHT_GRAY_CARPET");
    public static final dMaterial CYAN_CARPET = new dMaterial(Material.CARPET, 9).forceIdentifyAs("CYAN_CARPET");
    public static final dMaterial PURPLE_CARPET = new dMaterial(Material.CARPET, 10).forceIdentifyAs("PURPLE_CARPET");
    public static final dMaterial BLUE_CARPET = new dMaterial(Material.CARPET, 11).forceIdentifyAs("BLUE_CARPET");
    public static final dMaterial BROWN_CARPET = new dMaterial(Material.CARPET, 12).forceIdentifyAs("BROWN_CARPET");
    public static final dMaterial GREEN_CARPET = new dMaterial(Material.CARPET, 13).forceIdentifyAs("GREEN_CARPET");
    public static final dMaterial RED_CARPET = new dMaterial(Material.CARPET, 14).forceIdentifyAs("RED_CARPET");
    public static final dMaterial BLACK_CARPET = new dMaterial(Material.CARPET, 15).forceIdentifyAs("BLACK_CARPET");
    public static final dMaterial WHITE_CLAY = new dMaterial(Material.STAINED_CLAY, 0).forceIdentifyAs("WHITE_CLAY");
    public static final dMaterial ORANGE_CLAY = new dMaterial(Material.STAINED_CLAY, 1).forceIdentifyAs("ORANGE_CLAY");
    public static final dMaterial MAGENTA_CLAY = new dMaterial(Material.STAINED_CLAY, 2).forceIdentifyAs("MAGENTA_CLAY");
    public static final dMaterial LIGHT_BLUE_CLAY = new dMaterial(Material.STAINED_CLAY, 3).forceIdentifyAs("LIGHT_BLUE_CLAY");
    public static final dMaterial YELLOW_CLAY = new dMaterial(Material.STAINED_CLAY, 4).forceIdentifyAs("YELLOW_CLAY");
    public static final dMaterial LIME_CLAY = new dMaterial(Material.STAINED_CLAY, 5).forceIdentifyAs("LIME_CLAY");
    public static final dMaterial PINK_CLAY = new dMaterial(Material.STAINED_CLAY, 6).forceIdentifyAs("PINK_CLAY");
    public static final dMaterial GRAY_CLAY = new dMaterial(Material.STAINED_CLAY, 7).forceIdentifyAs("GRAY_CLAY");
    public static final dMaterial LIGHT_GRAY_CLAY = new dMaterial(Material.STAINED_CLAY, 8).forceIdentifyAs("LIGHT_GRAY_CLAY");
    public static final dMaterial CYAN_CLAY = new dMaterial(Material.STAINED_CLAY, 9).forceIdentifyAs("CYAN_CLAY");
    public static final dMaterial PURPLE_CLAY = new dMaterial(Material.STAINED_CLAY, 10).forceIdentifyAs("PURPLE_CLAY");
    public static final dMaterial BLUE_CLAY = new dMaterial(Material.STAINED_CLAY, 11).forceIdentifyAs("BLUE_CLAY");
    public static final dMaterial BROWN_CLAY = new dMaterial(Material.STAINED_CLAY, 12).forceIdentifyAs("BROWN_CLAY");
    public static final dMaterial GREEN_CLAY = new dMaterial(Material.STAINED_CLAY, 13).forceIdentifyAs("GREEN_CLAY");
    public static final dMaterial RED_CLAY = new dMaterial(Material.STAINED_CLAY, 14).forceIdentifyAs("RED_CLAY");
    public static final dMaterial BLACK_CLAY = new dMaterial(Material.STAINED_CLAY, 15).forceIdentifyAs("BLACK_CLAY");
    public static final dMaterial NATURAL_COAL = new dMaterial(Material.COAL, 0).forceIdentifyAs("NATURAL_COAL");
    public static final dMaterial CHARCOAL = new dMaterial(Material.COAL, 1).forceIdentifyAs("CHARCOAL");
    public static final dMaterial OAK_PLANKS = new dMaterial(Material.WOOD, 0).forceIdentifyAs("OAK_PLANKS");
    public static final dMaterial SPRUCE_PLANKS = new dMaterial(Material.WOOD, 1).forceIdentifyAs("SPRUCE_PLANKS");
    public static final dMaterial BIRCH_PLANKS = new dMaterial(Material.WOOD, 2).forceIdentifyAs("BIRCH_PLANKS");
    public static final dMaterial JUNGLE_PLANKS = new dMaterial(Material.WOOD, 3).forceIdentifyAs("JUNGLE_PLANKS");
    public static final dMaterial OAK_SAPLING = new dMaterial(Material.SAPLING, 0).forceIdentifyAs("OAK_SAPLING");
    public static final dMaterial SPRUCE_SAPLING = new dMaterial(Material.SAPLING, 1).forceIdentifyAs("SPRUCE_SAPLING");
    public static final dMaterial BIRCH_SAPLING = new dMaterial(Material.SAPLING, 2).forceIdentifyAs("BIRCH_SAPLING");
    public static final dMaterial JUNGLE_SAPLING = new dMaterial(Material.SAPLING, 3).forceIdentifyAs("JUNGLE_SAPLING");
    public static final dMaterial OAK_LEAVES = new dMaterial(Material.LEAVES, 0).forceIdentifyAs("OAK_LEAVES");
    public static final dMaterial SPRUCE_LEAVES = new dMaterial(Material.LEAVES, 1).forceIdentifyAs("SPRUCE_LEAVES");
    public static final dMaterial BIRCH_LEAVES = new dMaterial(Material.LEAVES, 2).forceIdentifyAs("BIRCH_LEAVES");
    public static final dMaterial JUNGLE_LEAVES = new dMaterial(Material.LEAVES, 3).forceIdentifyAs("JUNGLE_LEAVES");
    public static final dMaterial OAK_LOG = new dMaterial(Material.LOG, 0).forceIdentifyAs("OAK_LOG");
    public static final dMaterial SPRUCE_LOG = new dMaterial(Material.LOG, 1).forceIdentifyAs("SPRUCE_LOG");
    public static final dMaterial BIRCH_LOG = new dMaterial(Material.LOG, 2).forceIdentifyAs("BIRCH_LOG");
    public static final dMaterial JUNGLE_LOG = new dMaterial(Material.LOG, 3).forceIdentifyAs("JUNGLE_LOG");
    public static final dMaterial NATURAL_SANDSTONE = new dMaterial(Material.SANDSTONE, 0).forceIdentifyAs("NATURAL_SANDSTONE");
    public static final dMaterial CHISELED_SANDSTONE = new dMaterial(Material.SANDSTONE, 1).forceIdentifyAs("CHISELED_SANDSTONE");
    public static final dMaterial SMOOTH_SANDSTONE = new dMaterial(Material.SANDSTONE, 2).forceIdentifyAs("SMOOTH_SANDSTONE");
    public static final dMaterial STONE_BRICK = new dMaterial(Material.SMOOTH_BRICK, 0).forceIdentifyAs("STONE_BRICK");
    public static final dMaterial MOSSY_STONE_BRICK = new dMaterial(Material.SMOOTH_BRICK, 1).forceIdentifyAs("MOSSY_STONE_BRICK");
    public static final dMaterial CRACKED_STONE_BRICK = new dMaterial(Material.SMOOTH_BRICK, 2).forceIdentifyAs("CRACKED_STONE_BRICK");
    public static final dMaterial CHISELED_STONE_BRICK = new dMaterial(Material.SMOOTH_BRICK, 3).forceIdentifyAs("CHISELED_STONE_BRICK");
    public static final dMaterial INK = new dMaterial(Material.INK_SACK, 0).forceIdentifyAs("INK");
    public static final dMaterial RED_DYE = new dMaterial(Material.INK_SACK, 1).forceIdentifyAs("RED_DYE");
    public static final dMaterial GREEN_DYE = new dMaterial(Material.INK_SACK, 2).forceIdentifyAs("GREEN_DYE");
    public static final dMaterial COCOA_BEANS = new dMaterial(Material.INK_SACK, 3).forceIdentifyAs("COCOA_BEANS");
    public static final dMaterial LAPIS_LAZULI = new dMaterial(Material.INK_SACK, 4).forceIdentifyAs("LAPIS_LAZULI");
    public static final dMaterial PURPLE_DYE = new dMaterial(Material.INK_SACK, 5).forceIdentifyAs("PURPLE_DYE");
    public static final dMaterial CYAN_DYE = new dMaterial(Material.INK_SACK, 6).forceIdentifyAs("CYAN_DYE");
    public static final dMaterial LIGHT_GRAY_DYE = new dMaterial(Material.INK_SACK, 7).forceIdentifyAs("LIGHT_GRAY_DYE");
    public static final dMaterial GRAY_DYE = new dMaterial(Material.INK_SACK, 8).forceIdentifyAs("GRAY_DYE");
    public static final dMaterial PINK_DYE = new dMaterial(Material.INK_SACK, 9).forceIdentifyAs("PINK_DYE");
    public static final dMaterial LIME_DYE = new dMaterial(Material.INK_SACK, 10).forceIdentifyAs("LIME_DYE");
    public static final dMaterial YELLOW_DYE = new dMaterial(Material.INK_SACK, 11).forceIdentifyAs("YELLOW_DYE");
    public static final dMaterial LIGHT_BLUE_DYE = new dMaterial(Material.INK_SACK, 12).forceIdentifyAs("LIGHT_BLUE_DYE");
    public static final dMaterial MAGENTA_DYE = new dMaterial(Material.INK_SACK, 13).forceIdentifyAs("MAGENTA_DYE");
    public static final dMaterial ORANGE_DYE = new dMaterial(Material.INK_SACK, 14).forceIdentifyAs("ORANGE_DYE");
    public static final dMaterial BONE_MEAL = new dMaterial(Material.INK_SACK, 15).forceIdentifyAs("BONE_MEAL");
    public static final dMaterial SHRUB = new dMaterial(Material.LONG_GRASS, 0).forceIdentifyAs("SHRUB");
    public static final dMaterial TALL_GRASS = new dMaterial(Material.LONG_GRASS, 1).forceIdentifyAs("TALL_GRASS");
    public static final dMaterial FERN = new dMaterial(Material.LONG_GRASS, 2).forceIdentifyAs("FERN");
    public static final dMaterial EMPTY_POT = new dMaterial(Material.FLOWER_POT, 0).forceIdentifyAs("EMPTY_POT");
    public static final dMaterial POTTED_POPPY = new dMaterial(Material.FLOWER_POT, 1).forceIdentifyAs("POTTED_POPPY");
    public static final dMaterial POTTED_DAISY = new dMaterial(Material.FLOWER_POT, 2).forceIdentifyAs("POTTED_DAISY");
    public static final dMaterial POTTED_OAK_SAPLING = new dMaterial(Material.FLOWER_POT, 3).forceIdentifyAs("POTTED_OAK_SAPLING");
    public static final dMaterial POTTED_SPRUCE_SAPLING = new dMaterial(Material.FLOWER_POT, 4).forceIdentifyAs("POTTED_SPRUCE_SAPLING");
    public static final dMaterial POTTED_BIRCH_SAPLING = new dMaterial(Material.FLOWER_POT, 5).forceIdentifyAs("POTTED_BIRCH_SAPLING");
    public static final dMaterial POTTED_JUNGLE_SAPLING = new dMaterial(Material.FLOWER_POT, 6).forceIdentifyAs("POTTED_JUNGLE_SAPLING");
    public static final dMaterial POTTED_RED_MUSHROOM = new dMaterial(Material.FLOWER_POT, 7).forceIdentifyAs("POTTED_RED_MUSHROOM");
    public static final dMaterial POTTED_BROWN_MUSHROOM = new dMaterial(Material.FLOWER_POT, 8).forceIdentifyAs("POTTED_BROWN_MUSHROOM");
    public static final dMaterial POTTED_CACTUS = new dMaterial(Material.FLOWER_POT, 9).forceIdentifyAs("POTTED_CACTUS");
    public static final dMaterial POTTED_SHRUB = new dMaterial(Material.FLOWER_POT, 10).forceIdentifyAs("POTTED_SHRUB");
    public static final dMaterial POTTED_FERN = new dMaterial(Material.FLOWER_POT, 11).forceIdentifyAs("POTTED_FERN");
    public static final dMaterial SKELETON_SKULL = new dMaterial(Material.SKULL_ITEM, 0).forceIdentifyAs("SKELETON_SKULL");
    public static final dMaterial WITHERSKELETON_SKULL = new dMaterial(Material.SKULL_ITEM, 1).forceIdentifyAs("WITHERSKELETON_SKULL");
    public static final dMaterial ZOMBIE_SKULL = new dMaterial(Material.SKULL_ITEM, 2).forceIdentifyAs("ZOMBIE_SKULL");
    public static final dMaterial HUMAN_SKULL = new dMaterial(Material.SKULL_ITEM, 3).forceIdentifyAs("HUMAN_SKULL");
    public static final dMaterial CREEPER_SKULL = new dMaterial(Material.SKULL_ITEM, 4).forceIdentifyAs("CREEPER_SKULL");
    public static Map<Material, Map<Integer, dMaterial>> material_varieties = new HashMap<Material, Map<Integer, dMaterial>>();
    private String forcedIdentity = null;
    private Material material;
    private Byte data = 0;
    String prefix = "material";

    public static dMaterial registerVariety(dMaterial material) {
        Map<Integer, dMaterial> entry = material_varieties.containsKey(material.getMaterial()) ? material_varieties.get(material.getMaterial()) : new HashMap<Integer, dMaterial>();
        entry.put(Integer.valueOf(material.data.byteValue()), material);
        material_varieties.put(material.getMaterial(), entry);
        return material;
    }

    public static void _initialize() {
        for (dMaterials material : dMaterials.values()) {
            try {
                Field field = dMaterial.class.getField(material.name());
                dMaterial mat = (dMaterial)field.get(null);
                dMaterial.registerVariety(mat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private dMaterial forceIdentifyAs(String string) {
        this.forcedIdentity = string;
        return this;
    }

    public static dMaterial getMaterialFrom(Material material) {
        return dMaterial.getMaterialFrom(material, 0);
    }

    public static dMaterial getMaterialFrom(Material material, int data) {
        if (material == Material.AIR) {
            return AIR;
        }
        if (material_varieties.containsKey(material) && material_varieties.get(material).containsKey(data)) {
            return material_varieties.get(material).get(data);
        }
        return new dMaterial(material, data);
    }

    @ObjectFetcher(value="m")
    public static dMaterial valueOf(String string) {
        if (string.toLowerCase().matches("random") || string.toLowerCase().matches("m@random")) {
            return new dMaterial(Material.values()[Utilities.getRandom().nextInt(Material.values().length)]);
        }
        Matcher m = materialPattern.matcher(string);
        if (m.matches()) {
            int data = -1;
            if (m.group(2) != null) {
                data = aH.getIntegerFrom(m.group(2));
            }
            if (aH.matchesInteger(m.group(1))) {
                return dMaterial.getMaterialFrom(Material.getMaterial((int)aH.getIntegerFrom(m.group(1))), data);
            }
            for (Material material : Material.values()) {
                if (!material.name().equalsIgnoreCase(m.group(1))) continue;
                return dMaterial.getMaterialFrom(material, data);
            }
            for (dMaterials dMaterials2 : dMaterials.values()) {
                if (!dMaterials2.name().equalsIgnoreCase(m.group(1))) continue;
                try {
                    Field field = dMaterial.class.getField(dMaterials2.name());
                    field.setAccessible(true);
                    return (dMaterial)field.get(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.toUpperCase().matches("(?:m@)?RANDOM")) {
            return true;
        }
        Matcher m = materialPattern.matcher(arg);
        return m.matches();
    }

    public boolean equals(Object object) {
        if (object instanceof dMaterial) {
            return ((dMaterial)object).identify() == this.identify();
        }
        return dMaterial.valueOf(object.toString()) != null && dMaterial.valueOf(object.toString()).identify() == this.identify();
    }

    private dMaterial(Material material, int data) {
        this.material = material;
        this.data = data < 0 ? null : Byte.valueOf((byte)data);
    }

    private dMaterial(Material material) {
        this(material, 0);
    }

    public Material getMaterial() {
        return this.material;
    }

    public String name() {
        return this.material.name();
    }

    public Byte getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean matchesMaterialData(MaterialData data) {
        if (this.hasData()) {
            return this.material == data.getItemType() && data.getData() == data.getData();
        }
        return this.material == data.getItemType();
    }

    public MaterialData getMaterialData() {
        return new MaterialData(this.material, this.data != null ? this.data : (byte)0);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getObjectType() {
        return "Material";
    }

    public String identify() {
        if (this.forcedIdentity != null) {
            return "m@" + this.forcedIdentity.toLowerCase();
        }
        return "m@" + this.material.name().toLowerCase();
    }

    public String toString() {
        return this.identify();
    }

    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("has_gravity")) {
            return new Element(this.material.hasGravity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new Element(this.material.getId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_block")) {
            return new Element(this.material.isBlock()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_burnable")) {
            return new Element(this.material.isBurnable()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_edible")) {
            return new Element(this.material.isEdible()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flammable")) {
            return new Element(this.material.isFlammable()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_occluding")) {
            return new Element(this.material.isOccluding()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_record")) {
            return new Element(this.material.isRecord()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_solid")) {
            return new Element(this.material.isSolid()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_transparent")) {
            return new Element(this.material.isTransparent()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_durability")) {
            return new Element(this.material.getMaxDurability()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_stack_size")) {
            return new Element(this.material.getMaxStackSize()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_made_of")) {
            dMaterial compared = dMaterial.valueOf(attribute.getContext(1));
            if (compared == null) {
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            return new Element(this.material.name().equalsIgnoreCase(compared.getMaterial().name())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("bukkit_enum")) {
            return new Element(this.material.name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("data")) {
            return new Element(this.material.name()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum dMaterials {
        WHITE_WOOL,
        ORANGE_WOOL,
        MAGENTA_WOOL,
        LIGHT_BLUE_WOOL,
        YELLOW_WOOL,
        LIME_WOOL,
        PINK_WOOL,
        GRAY_WOOL,
        LIGHT_GRAY_WOOL,
        CYAN_WOOL,
        PURPLE_WOOL,
        BLUE_WOOL,
        BROWN_WOOL,
        GREEN_WOOL,
        RED_WOOL,
        BLACK_WOOL,
        WHITE_CARPET,
        ORANGE_CARPET,
        MAGENTA_CARPET,
        LIGHT_BLUE_CARPET,
        YELLOW_CARPET,
        LIME_CARPET,
        PINK_CARPET,
        GRAY_CARPET,
        LIGHT_GRAY_CARPET,
        CYAN_CARPET,
        PURPLE_CARPET,
        BLUE_CARPET,
        BROWN_CARPET,
        GREEN_CARPET,
        RED_CARPET,
        BLACK_CARPET,
        WHITE_CLAY,
        ORANGE_CLAY,
        MAGENTA_CLAY,
        LIGHT_BLUE_CLAY,
        YELLOW_CLAY,
        LIME_CLAY,
        PINK_CLAY,
        GRAY_CLAY,
        LIGHT_GRAY_CLAY,
        CYAN_CLAY,
        PURPLE_CLAY,
        BLUE_CLAY,
        BROWN_CLAY,
        GREEN_CLAY,
        RED_CLAY,
        BLACK_CLAY,
        NATURAL_COAL,
        CHARCOAL,
        OAK_PLANKS,
        SPRUCE_PLANKS,
        BIRCH_PLANKS,
        JUNGLE_PLANKS,
        OAK_SAPLING,
        SPRUCE_SAPLING,
        BIRCH_SAPLING,
        JUNGLE_SAPLING,
        OAK_LEAVES,
        SPRUCE_LEAVES,
        BIRCH_LEAVES,
        JUNGLE_LEAVES,
        OAK_LOG,
        SPRUCE_LOG,
        BIRCH_LOG,
        JUNGLE_LOG,
        NATURAL_SANDSTONE,
        CHISELED_SANDSTONE,
        SMOOTH_SANDSTONE,
        STONE_BRICK,
        MOSSY_STONE_BRICK,
        CRACKED_STONE_BRICK,
        CHISELED_STONE_BRICK,
        INK,
        RED_DYE,
        GREEN_DYE,
        COCOA_BEANS,
        LAPIS_LAZULI,
        PURPLE_DYE,
        CYAN_DYE,
        LIGHT_GRAY_DYE,
        GRAY_DYE,
        PINK_DYE,
        LIME_DYE,
        YELLOW_DYE,
        LIGHT_BLUE_DYE,
        MAGENTA_DYE,
        ORANGE_DYE,
        BONE_MEAL,
        TALL_GRASS,
        FERN,
        SHRUB,
        EMPTY_POT,
        POTTED_POPPY,
        POTTED_DAISY,
        POTTED_OAK_SAPLING,
        POTTED_SPRUCE_SAPLING,
        POTTED_BIRCH_SAPLING,
        POTTED_JUNGLE_SAPLING,
        POTTED_RED_MUSHROOM,
        POTTED_BROWN_MUSHROOM,
        POTTED_CACTUS,
        POTTED_SHRUB,
        POTTED_FERN,
        SKELETON_SKULL,
        WITHERSKELETON_SKULL,
        ZOMBIE_SKULL,
        HUMAN_SKULL,
        CREEPER_SKULL;

    }
}

