/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties;

import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.tags.Attribute;
import org.bukkit.Rotation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;

public class EntityFramed
implements Property {
    dEntity item_frame;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        return ((dEntity)entity).getEntityType() == EntityType.ITEM_FRAME;
    }

    public static EntityFramed getFrom(dObject entity) {
        if (!EntityFramed.describes(entity)) {
            return null;
        }
        return new EntityFramed((dEntity)entity);
    }

    private EntityFramed(dEntity item) {
        this.item_frame = item;
    }

    public boolean hasItem() {
        return this.getItemFrameEntity().getItem() != null;
    }

    public ItemFrame getItemFrameEntity() {
        return (ItemFrame)this.item_frame.getBukkitEntity();
    }

    public void setItem(dItem item) {
        this.getItemFrameEntity().setItem(item.getItemStack());
    }

    public dItem getItem() {
        return new dItem(this.getItemFrameEntity().getItem());
    }

    public String getPropertyString() {
        return this.getPropertyId() + '=' + this.getItem().getMaterial().identify() + (this.getItemFrameEntity().getRotation() == Rotation.NONE ? Character.valueOf(';') : '|' + this.getItemFrameEntity().getRotation().name().toLowerCase() + ';');
    }

    public String getPropertyId() {
        return "framed";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("framed_item")) {
            return this.getItem().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_framed_item")) {
            return new Element(this.hasItem()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("framed_item_rotation")) {
            return new Element(this.getItemFrameEntity().getRotation().name().toLowerCase()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

