/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.properties.EntityAge;
import net.aufdemrand.denizen.objects.properties.EntityFramed;
import net.aufdemrand.denizen.objects.properties.EntityInfected;
import net.aufdemrand.denizen.objects.properties.EntityProfession;
import net.aufdemrand.denizen.objects.properties.ItemColor;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyParser {
    public static String NONE = "";
    static Map<Class<? extends dObject>, List<Class>> properties = new HashMap<Class<? extends dObject>, List<Class>>();
    static Map<Class, Method> describes = new WeakHashMap<Class, Method>();
    static Map<Class, Method> getFrom = new WeakHashMap<Class, Method>();

    public PropertyParser() {
        this.registerProperty(EntityProfession.class, dEntity.class);
        this.registerProperty(EntityAge.class, dEntity.class);
        this.registerProperty(EntityFramed.class, dEntity.class);
        this.registerProperty(EntityInfected.class, dEntity.class);
        this.registerProperty(ItemColor.class, dItem.class);
    }

    public void registerProperty(Class property, Class<? extends dObject> object) {
        List<Object> prop_list = properties.containsKey(object) ? properties.get(object) : new ArrayList();
        prop_list.add(property);
        properties.put(object, prop_list);
        try {
            describes.put(property, property.getMethod("describes", dObject.class));
            getFrom.put(property, property.getMethod("getFrom", dObject.class));
        }
        catch (NoSuchMethodException e) {
            dB.echoError("Unable to register property '" + property.getSimpleName() + "'!");
        }
    }

    public static String getPropertiesString(dObject object) {
        StringBuilder prop_string = new StringBuilder();
        try {
            for (Class property : properties.get(object.getClass())) {
                if (!((Boolean)describes.get(property).invoke(null, object)).booleanValue()) continue;
                prop_string.append(((Property)getFrom.get(property).invoke(null, object)).getPropertyString());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return prop_string.toString();
    }

    public static List<Property> getProperties(dObject object) {
        ArrayList<Property> props = new ArrayList<Property>();
        try {
            for (Class property : properties.get(object.getClass())) {
                if (!((Boolean)describes.get(property).invoke(null, object)).booleanValue()) continue;
                props.add((Property)getFrom.get(property).invoke(null, object));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return props;
    }
}

