/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.ObjectFetcher;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class NoteCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("as, i, id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!ObjectFetcher.canFetch(arg.getValue().split("@")[0])) continue;
            scriptEntry.addObject("object", arg.getValue());
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an id");
        }
        if (!scriptEntry.hasObject("object")) {
            throw new InvalidArgumentsException("Must specify a fetchable-object to note.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String object = (String)scriptEntry.getObject("object");
        Element id = scriptEntry.getElement("id");
        dB.report(this.getName(), aH.debugObj("object", object) + id.debug());
        String object_type = object.split("@")[0].toLowerCase();
        Class object_class = ObjectFetcher.getObjectClass(object_type);
        if (object_class == null) {
            dB.echoError("Invalid object type! Could not fetch '" + object_type + "'!");
            return;
        }
        try {
            if (!((Boolean)object_class.getMethod("matches", String.class).invoke(null, object)).booleanValue()) {
                dB.echoDebug("'" + object + "' is an invalid " + object_class.getSimpleName() + ".");
                return;
            }
            dObject arg = (dObject)object_class.getMethod("valueOf", String.class).invoke(null, object);
            if (arg instanceof Notable) {
                ((Notable)((Object)arg)).makeUnique(id.asString());
            }
        }
        catch (Exception e) {
            dB.echoError("Uh oh! Report this to aufdemrand! Err: TagManagerObjectReflection");
            e.printStackTrace();
        }
    }
}

