/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.traits.ChatbotTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    static final Pattern triggerPattern = Pattern.compile("\\/([^/]*)\\/");

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public Boolean process(Player player, String message) {
        InteractScriptContainer script;
        dNPC npc = Utilities.getClosestNPC(player.getLocation(), 25);
        dPlayer denizenPlayer = dPlayer.mirrorBukkitPlayer((OfflinePlayer)player);
        if (npc == null) {
            return false;
        }
        if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
            return false;
        }
        if (!((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return false;
        }
        if (npc.getTriggerTrait().getRadius(this.name) < npc.getLocation().distance(player.getLocation())) {
            return false;
        }
        dB.report(this.name, aH.debugObj("Player", player.getName()) + aH.debugObj("NPC", npc.toString()) + aH.debugObj("Radius(Max)", npc.getLocation().distance(player.getLocation()) + "(" + npc.getTriggerTrait().getRadius(this.name) + ")") + aH.debugObj("Trigger text", message) + aH.debugObj("LOS", String.valueOf(player.hasLineOfSight((Entity)npc.getEntity()))) + aH.debugObj("Facing", String.valueOf(Rotation.isFacingEntity((Entity)player, (Entity)npc.getEntity(), 45.0f))));
        if (Settings.ChatMustSeeNPC() && !player.hasLineOfSight((Entity)npc.getEntity())) {
            return false;
        }
        if (Settings.ChatMustLookAtNPC() && !Rotation.isFacingEntity((Entity)player, (Entity)npc.getEntity(), 45.0f)) {
            return false;
        }
        Boolean ret = false;
        if (!npc.getTriggerTrait().trigger(this, denizenPlayer)) {
            if (Settings.ChatGloballyIfUninteractable()) {
                dB.echoDebug(ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                return false;
            }
            ret = true;
        }
        if ((script = npc.getInteractScript(denizenPlayer, ChatTrigger.class)) == null) {
            return false;
        }
        if (!script.containsTriggerInStep(InteractScriptHelper.getCurrentStep(denizenPlayer, script.getName()), ChatTrigger.class)) {
            if (npc.getCitizen().hasTrait(ChatbotTrait.class)) {
                Utilities.talkToNPC(message, denizenPlayer, npc, Settings.ChatToNpcOverhearingRange());
                ((ChatbotTrait)npc.getCitizen().getTrait(ChatbotTrait.class)).chatTo((LivingEntity)player, message);
                return true;
            }
            if (!Settings.ChatGloballyIfNoChatTriggers()) {
                dB.echoDebug(player.getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + message);
                return true;
            }
            return ret;
        }
        String id = null;
        boolean matched = false;
        String replacementText = null;
        String regexId = null;
        String regexMessage = null;
        TreeMap<String, String> idMap = new TreeMap<String, String>();
        idMap.putAll(script.getIdMapFor(ChatTrigger.class, denizenPlayer));
        if (!idMap.isEmpty()) {
            for (Map.Entry entry : idMap.entrySet()) {
                Matcher matcher = triggerPattern.matcher((CharSequence)entry.getValue());
                while (matcher.find()) {
                    if (!script.checkSpecificTriggerScriptRequirementsFor(ChatTrigger.class, denizenPlayer, npc, (String)entry.getKey())) continue;
                    String keyword = TagManager.tag(denizenPlayer, npc, matcher.group().replace("/", ""));
                    if (regexId == null && this.isKeywordRegex(keyword)) {
                        Pattern pattern = Pattern.compile(keyword.substring(6));
                        Matcher m = pattern.matcher(message);
                        if (!m.find()) continue;
                        regexId = (String)entry.getKey();
                        regexMessage = ((String)entry.getValue()).replace(matcher.group(), m.group());
                        dB.log("entry value: " + (String)entry.getValue() + "  keyword: " + keyword + "  m.group: " + m.group() + "  matcher.group: " + matcher.group());
                        continue;
                    }
                    if (this.isKeywordStrict(keyword)) {
                        if (!message.toUpperCase().equalsIgnoreCase(keyword.toUpperCase())) continue;
                        id = (String)entry.getKey();
                        replacementText = ((String)entry.getValue()).replace("/", "");
                        matched = true;
                        continue;
                    }
                    if (!message.toUpperCase().contains(keyword.toUpperCase())) continue;
                    id = (String)entry.getKey();
                    replacementText = ((String)entry.getValue()).replace("/", "");
                    matched = true;
                }
                if (!matched) continue;
                break;
            }
        }
        if (!matched && regexId != null) {
            id = regexId;
            replacementText = regexMessage;
        }
        if (id != null) {
            Utilities.talkToNPC(replacementText, denizenPlayer, npc, Settings.ChatToNpcOverhearingRange());
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("message", new Element(message));
            this.parse(npc, denizenPlayer, script, id, context);
            return true;
        }
        if (npc.getCitizen().hasTrait(ChatbotTrait.class)) {
            Utilities.talkToNPC(message, denizenPlayer, npc, Settings.ChatToNpcOverhearingRange());
            ((ChatbotTrait)npc.getCitizen().getTrait(ChatbotTrait.class)).chatTo((LivingEntity)player, message);
            return true;
        }
        if (!Settings.ChatGloballyIfFailedChatTriggers()) {
            Utilities.talkToNPC(message, denizenPlayer, npc, Settings.ChatToNpcOverhearingRange());
            return true;
        }
        return ret;
    }

    @EventHandler
    public void asyncChatTrigger(final AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!Settings.ChatAsynchronous()) {
            return;
        }
        Callable<Boolean> call = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ChatTrigger.this.process(event.getPlayer(), event.getMessage());
            }
        };
        Boolean cancelled = false;
        try {
            cancelled = event.isAsynchronous() ? (Boolean)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get() : (Boolean)call.call();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        event.setCancelled(cancelled.booleanValue());
    }

    @EventHandler
    public void syncChatTrigger(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (Settings.ChatAsynchronous()) {
            return;
        }
        Boolean cancelled = this.process(event.getPlayer(), event.getMessage());
        event.setCancelled(cancelled.booleanValue());
    }

    private boolean isKeywordRegex(String keyWord) {
        return keyWord.toUpperCase().startsWith("REGEX:");
    }

    private boolean isKeywordStrict(String keyWord) {
        return keyWord.toUpperCase().startsWith("STRICT:");
    }
}

