/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dList
extends ArrayList<String>
implements dObject {
    static final Pattern flag_by_id = Pattern.compile("(fl\\[((?:p@|n@)(.+?))\\]@|fl@)(.+)", 2);
    static final Pattern split_char = Pattern.compile("\\|");
    static final Pattern identifier = Pattern.compile("li@", 2);
    private FlagManager.Flag flag = null;
    private String prefix = "List";

    @ObjectFetcher(value="li, fl")
    public static dList valueOf(String string) {
        if (string == null) {
            return null;
        }
        Matcher m = flag_by_id.matcher(string);
        if (m.matches()) {
            FlagManager flag_manager = DenizenAPI.getCurrentInstance().flagManager();
            try {
                if (m.group(1).equalsIgnoreCase("fl@")) {
                    if (FlagManager.serverHasFlag(m.group(4))) {
                        return new dList(flag_manager.getGlobalFlag(m.group(4)));
                    }
                } else if (m.group(2).toLowerCase().startsWith("p@")) {
                    if (FlagManager.playerHasFlag(dPlayer.valueOf(m.group(3)), m.group(4))) {
                        return new dList(flag_manager.getPlayerFlag(m.group(3), m.group(4)));
                    }
                } else if (m.group(2).toLowerCase().startsWith("n@") && FlagManager.npcHasFlag(dNPC.valueOf(m.group(3)), m.group(4))) {
                    return new dList(flag_manager.getNPCFlag(Integer.valueOf(m.group(3)), m.group(4)));
                }
            }
            catch (Exception e) {
                dB.echoDebug("Flag '" + m.group() + "' could not be found!");
                return null;
            }
        }
        return new dList(string.replaceFirst(identifier.pattern(), ""));
    }

    public static boolean matches(String arg) {
        Matcher m = flag_by_id.matcher(arg);
        return m.matches() || arg.contains("|") || arg.toLowerCase().startsWith("li@");
    }

    public dList(ArrayList<? extends dObject> dObjectList) {
        for (dObject dObject2 : dObjectList) {
            this.add(dObject2.identify());
        }
    }

    public dList() {
    }

    public dList(String items) {
        if (items != null) {
            this.addAll(Arrays.asList(split_char.split(items)));
        }
    }

    public dList(List<String> items) {
        if (items != null) {
            this.addAll(items);
        }
    }

    public dList(List<String> items, String prefix) {
        for (String element : items) {
            this.add(prefix + element);
        }
    }

    public dList(FlagManager.Flag flag) {
        this.flag = flag;
        this.addAll(flag.values());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dList setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return this.flag != null;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    public String[] toArray() {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            list.add(string);
        }
        return list.toArray(new String[list.size()]);
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            for (Enum value : values) {
                if (!value.name().equalsIgnoreCase(string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public List<dObject> filter(Class<? extends dObject> dClass) {
        return this.filter(dClass, null);
    }

    public List<dObject> filter(Class<? extends dObject> dClass, ScriptEntry entry) {
        ArrayList<dObject> results = new ArrayList<dObject>();
        for (String element : this) {
            try {
                dObject object;
                if (!((Boolean)dClass.getMethod("matches", String.class).invoke(null, element)).booleanValue() || (object = (dObject)(dClass == dItem.class && entry != null ? dItem.valueOf(element, entry.getPlayer(), entry.getNPC()) : dClass.getMethod("valueOf", String.class).invoke(null, element))) == null) continue;
                results.add(object);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.identify();
    }

    @Override
    public String identify() {
        if (this.flag != null) {
            return this.flag.toString();
        }
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder dScriptArg = new StringBuilder();
        dScriptArg.append("li@");
        for (String item : this) {
            dScriptArg.append(item);
            dScriptArg.append('|');
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - 1);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("ascslist") || attribute.startsWith("as_cslist")) {
            if (this.isEmpty()) {
                return new Element("").getAttribute(attribute.fulfill(1));
            }
            StringBuilder dScriptArg = new StringBuilder();
            for (String item : this) {
                dScriptArg.append(item);
                dScriptArg.append(", ");
            }
            return new Element(dScriptArg.toString().substring(0, dScriptArg.length() - 2)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("formatted")) {
            if (this.isEmpty()) {
                return new Element("").getAttribute(attribute.fulfill(1));
            }
            StringBuilder dScriptArg = new StringBuilder();
            for (int n = 0; n < this.size(); ++n) {
                dScriptArg.append(((String)this.get(n)).replaceAll("\\w\\w?@", ""));
                if (n == this.size() - 2) {
                    dScriptArg.append(" and ");
                    continue;
                }
                dScriptArg.append(", ");
            }
            return new Element(dScriptArg.toString().substring(0, dScriptArg.length() - 2)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("size")) {
            return new Element(this.size()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_empty")) {
            return new Element(this.isEmpty()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asstring") || attribute.startsWith("as_string")) {
            if (this.isEmpty()) {
                return new Element("").getAttribute(attribute.fulfill(1));
            }
            StringBuilder dScriptArg = new StringBuilder();
            for (String item : this) {
                dScriptArg.append(item);
                dScriptArg.append(' ');
            }
            return new Element(dScriptArg.toString().substring(0, dScriptArg.length() - 1)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("exclude")) {
            String[] exclusions = split_char.split(attribute.getContext(1));
            dList list = new dList(this);
            for (String exclusion : exclusions) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(exclusion)) continue;
                    list.remove(i--);
                }
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get")) {
            if (this.isEmpty()) {
                return "null";
            }
            int index = attribute.getIntContext(1);
            if (index > this.size()) {
                return "null";
            }
            String item = index > 0 ? (String)this.get(index - 1) : (String)this.get(0);
            return new Element(item).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("find") && attribute.hasContext(1)) {
            int i;
            for (i = 0; i < this.size(); ++i) {
                if (!((String)this.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                return new Element(i + 1).getAttribute(attribute.fulfill(1));
            }
            for (i = 0; i < this.size(); ++i) {
                if (!((String)this.get(i)).toUpperCase().contains(attribute.getContext(1).toUpperCase())) continue;
                return new Element(i + 1).getAttribute(attribute.fulfill(1));
            }
            return new Element(-1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last")) {
            return new Element((String)this.get(this.size() - 1)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("contains") && attribute.hasContext(1)) {
            boolean state = false;
            for (String element : this) {
                if (!element.equalsIgnoreCase(attribute.getContext(1))) continue;
                state = true;
                break;
            }
            return new Element(state).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("identify")) {
            return new Element(this.identify()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element(this.getObjectType()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("random") && !this.isEmpty()) {
            if (attribute.hasContext(1)) {
                int count = Integer.valueOf(attribute.getContext(1));
                ArrayList<String> available = new ArrayList<String>();
                available.addAll(this);
                dList toReturn = new dList();
                for (int times = 0; !available.isEmpty() && times < count; ++times) {
                    int random = Utilities.getRandom().nextInt(available.size());
                    toReturn.add(available.get(random));
                    available.remove(random);
                }
                return toReturn.getAttribute(attribute.fulfill(1));
            }
            return new Element((String)this.get(Utilities.getRandom().nextInt(this.size()))).getAttribute(attribute.fulfill(1));
        }
        if (this.flag != null && attribute.startsWith("expiration")) {
            return this.flag.expiration().getAttribute(attribute.fulfill(1));
        }
        if (this.flag != null && (attribute.startsWith("as_list") || attribute.startsWith("aslist"))) {
            return new dList(this).getAttribute(attribute.fulfill(1));
        }
        return this.flag != null ? new Element(this.flag.getLast().asString()).getAttribute(attribute) : new Element(this.identify()).getAttribute(attribute);
    }
}

