/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.ParticleEffect;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Effect;
import org.bukkit.Location;

public class PlayEffectCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("effect") && !scriptEntry.hasObject("particleeffect")) {
                if (arg.matchesEnum((Enum[])Effect.values())) {
                    scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                    continue;
                }
                if (!arg.matchesEnum(ParticleEffect.values())) continue;
                scriptEntry.addObject("particleeffect", (Object)ParticleEffect.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("visibility") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("visibility, v, radius, r")) {
                scriptEntry.addObject("visibility", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("data, d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer) && arg.matchesPrefix("qty, q")) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("offset, o")) {
                scriptEntry.addObject("offset", arg.asElement());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        scriptEntry.defaultObject("location", scriptEntry.hasNPC() ? scriptEntry.getNPC().getLocation() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getLocation() : null);
        scriptEntry.defaultObject("data", new Element(0));
        scriptEntry.defaultObject("visibility", new Element(5));
        scriptEntry.defaultObject("qty", new Element(1));
        scriptEntry.defaultObject("offset", new Element(0.5));
        if (!scriptEntry.hasObject("effect") && !scriptEntry.hasObject("particleeffect")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "EFFECT");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        ParticleEffect particleEffect = (ParticleEffect)((Object)scriptEntry.getObject("particleeffect"));
        Element visibility = (Element)scriptEntry.getObject("visibility");
        Element data = (Element)scriptEntry.getObject("data");
        Element qty = (Element)scriptEntry.getObject("qty");
        Element offset = (Element)scriptEntry.getObject("offset");
        location.add(0.0, 1.0, 0.0);
        dB.report(this.getName(), (effect != null ? aH.debugObj("effect", effect.name()) : aH.debugObj("special effect", particleEffect.name())) + aH.debugObj("location", location.toString()) + aH.debugObj("radius", visibility) + aH.debugObj("data", data) + aH.debugObj("qty", qty) + (effect != null ? "" : aH.debugObj("offset", offset)));
        if (effect != null) {
            for (int n = 0; n < qty.asInt(); ++n) {
                location.getWorld().playEffect((Location)location, effect, data.asInt(), visibility.asInt());
            }
        } else {
            ParticleEffect.valueOf(particleEffect.name()).play(location, visibility.asDouble(), offset.asFloat(), offset.asFloat(), offset.asFloat(), data.asFloat(), qty.asInt());
        }
    }
}

