/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.CommandHandler;
import net.aufdemrand.denizen.events.SavesReloadEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.listeners.ListenerRegistry;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.ChatbotTrait;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.FishingTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.HungerTrait;
import net.aufdemrand.denizen.npc.traits.InvisibleTrait;
import net.aufdemrand.denizen.npc.traits.MobproxTrait;
import net.aufdemrand.denizen.npc.traits.NameplateTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.ParticlesTrait;
import net.aufdemrand.denizen.npc.traits.PushableTrait;
import net.aufdemrand.denizen.npc.traits.SittingTrait;
import net.aufdemrand.denizen.npc.traits.SleepingTrait;
import net.aufdemrand.denizen.npc.traits.SneakingTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.properties.PropertyParser;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.CommandRegistry;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptHelper;
import net.aufdemrand.denizen.scripts.queues.ScriptEngine;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.scripts.requirements.RequirementRegistry;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.aufdemrand.denizen.tags.ObjectFetcher;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.RuntimeCompiler;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Denizen
extends JavaPlugin {
    public static final int configVersion = 4;
    public static String versionTag = null;
    private boolean startedSuccessful = false;
    private CommandHandler commandHandler;
    private ScriptEngine scriptEngine = new ScriptEngine(this);
    private CommandRegistry commandRegistry = new CommandRegistry(this);
    private TriggerRegistry triggerRegistry = new TriggerRegistry();
    private RequirementRegistry requirementRegistry = new RequirementRegistry(this);
    private ListenerRegistry listenerRegistry = new ListenerRegistry();
    private dNPCRegistry dNPCRegistry;
    private PropertyParser propertyParser;
    private FlagManager flagManager = new FlagManager(this);
    private TagManager tagManager = new TagManager(this);
    private NotableManager notableManager = new NotableManager();
    public Depends depends = new Depends();
    private FileConfiguration savesConfig = null;
    private File savesConfigFile = null;
    private FileConfiguration scoreboardsConfig = null;
    private File scoreboardsConfigFile = null;
    Citizens citizens;

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public dNPCRegistry getNPCRegistry() {
        return this.dNPCRegistry;
    }

    public ListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public RequirementRegistry getRequirementRegistry() {
        return this.requirementRegistry;
    }

    public TriggerRegistry getTriggerRegistry() {
        return this.triggerRegistry;
    }

    private PropertyParser getPropertyParser() {
        return this.propertyParser;
    }

    public FlagManager flagManager() {
        return this.flagManager;
    }

    public TagManager tagManager() {
        return this.tagManager;
    }

    public NotableManager notableManager() {
        return this.notableManager;
    }

    public void onEnable() {
        this.depends.initialize();
        if (Depends.citizens == null || !Depends.citizens.isEnabled()) {
            dB.echoError("Citizens does not seem to be activated! Deactivating Denizen!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.startedSuccessful = true;
        versionTag = this.getDescription().getVersion();
        dB.echoDebug(dB.DebugElement.Footer);
        dB.echoDebug(ChatColor.YELLOW + " _/_ _  ._  _ _  ");
        dB.echoDebug(ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable minecraft");
        dB.echoDebug(dB.DebugElement.Spacer);
        dB.echoDebug(ChatColor.GRAY + "by: " + ChatColor.WHITE + "aufdemrand");
        dB.echoDebug(ChatColor.GRAY + "version: " + ChatColor.WHITE + versionTag);
        dB.echoDebug(dB.DebugElement.Footer);
        this.dNPCRegistry = new dNPCRegistry(this);
        this.commandHandler = new CommandHandler(Depends.citizens);
        ScriptRegistry._registerCoreTypes();
        this.saveDefaultConfig();
        this.reloadConfig();
        String directory = URLDecoder.decode(System.getProperty("user.dir"));
        new File(directory + "/plugins/Denizen/scripts").mkdirs();
        new File(directory + "/plugins/Denizen/midi").mkdirs();
        new File(directory + "/plugins/Denizen/schematics").mkdirs();
        if (!new File(directory + "/plugins/Denizen/midi/Denizen.mid").exists()) {
            String sourceFile = URLDecoder.decode(Denizen.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            dB.echoDebug("Denizen.mid not found, extracting from " + sourceFile);
            Utilities.extractFile(new File(sourceFile), "Denizen.mid", directory + "/plugins/Denizen/midi/");
        }
        if (!this.getConfig().isSet("Config.Version") || this.getConfig().getInt("Config.Version", 0) != 4) {
            dB.echoError("Your Denizen config file is from a different version. Some settings will not be available unless you generate a new one. This is easily done by stopping the server, deleting the current config.yml file in the Denizen folder and restarting the server.");
        }
        ScriptHelper.reloadScripts();
        this.reloadSaves();
        WorldScriptHelper ws_helper = new WorldScriptHelper();
        ItemScriptHelper is_helper = new ItemScriptHelper();
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(TriggerTrait.class).withName("triggers"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PushableTrait.class).withName("pushable"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(AssignmentTrait.class).withName("assignment"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(NicknameTrait.class).withName("nickname"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HealthTrait.class).withName("health"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ConstantsTrait.class).withName("constants"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(NameplateTrait.class).withName("nameplate"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HungerTrait.class).withName("hunger"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SittingTrait.class).withName("sitting"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(FishingTrait.class).withName("fishing"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SleepingTrait.class).withName("sleeping"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ParticlesTrait.class).withName("particles"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SneakingTrait.class).withName("sneaking"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(InvisibleTrait.class).withName("invisible"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(MobproxTrait.class).withName("mobprox"));
        if (Depends.hasProgramAB) {
            CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ChatbotTrait.class).withName("chatbot"));
        }
        if (Depends.protocolManager != null) {
            new PacketHelper(this);
            dB.echoApproval("ProtocolLib hooked, traits and commands with custom packages can be used!");
        }
        RuntimeCompiler compiler = new RuntimeCompiler(this);
        compiler.loader();
        this.getCommandRegistry().registerCoreMembers();
        this.getTriggerRegistry().registerCoreMembers();
        this.getRequirementRegistry().registerCoreMembers();
        this.getListenerRegistry().registerCoreMembers();
        this.tagManager().registerCoreTags();
        Depends.citizens.registerCommandClass(CommandHandler.class);
        try {
            ObjectFetcher.registerWithObjectFetcher(dItem.class);
            ObjectFetcher.registerWithObjectFetcher(dCuboid.class);
            ObjectFetcher.registerWithObjectFetcher(dEntity.class);
            ObjectFetcher.registerWithObjectFetcher(dInventory.class);
            ObjectFetcher.registerWithObjectFetcher(dColor.class);
            ObjectFetcher.registerWithObjectFetcher(dList.class);
            ObjectFetcher.registerWithObjectFetcher(dLocation.class);
            ObjectFetcher.registerWithObjectFetcher(dMaterial.class);
            ObjectFetcher.registerWithObjectFetcher(dNPC.class);
            ObjectFetcher.registerWithObjectFetcher(dPlayer.class);
            ObjectFetcher.registerWithObjectFetcher(dScript.class);
            ObjectFetcher.registerWithObjectFetcher(dWorld.class);
            ObjectFetcher.registerWithObjectFetcher(Element.class);
            ObjectFetcher.registerWithObjectFetcher(Duration.class);
            ObjectFetcher.registerWithObjectFetcher(dChunk.class);
            ObjectFetcher._initialize();
            NotableManager.registerWithNotableManager(dCuboid.class);
            NotableManager._initialize();
        }
        catch (Exception e) {
            // empty catch block
        }
        dMaterial._initialize();
        this.propertyParser = new PropertyParser();
        dB.echoDebug(dB.DebugElement.Footer);
        ScriptHelper.reloadScripts();
        ws_helper.serverStartEvent();
    }

    public void onDisable() {
        if (!this.startedSuccessful) {
            return;
        }
        dLocation._saveLocations();
        ScoreboardHelper._saveScoreboards();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.getListenerRegistry().deconstructPlayer(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player));
        }
        for (Player player : this.getServer().getOfflinePlayers()) {
            try {
                this.getListenerRegistry().deconstructPlayer(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            catch (Exception e) {
                if (player == null) {
                    dB.echoDebug("Tell aufdemrand ASAP about this error! ERR: OPN");
                    continue;
                }
                dB.echoError("'" + player.getName() + "' is having trouble deconstructing! " + "You might have a corrupt player file!");
            }
        }
        this.getCommandRegistry().disableCoreMembers();
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        this.saveSaves();
    }

    public void reloadSaves() {
        if (this.savesConfigFile == null) {
            this.savesConfigFile = new File(this.getDataFolder(), "saves.yml");
        }
        this.savesConfig = YamlConfiguration.loadConfiguration((File)this.savesConfigFile);
        dLocation._recallLocations();
        if (this.scoreboardsConfigFile == null) {
            this.scoreboardsConfigFile = new File(this.getDataFolder(), "scoreboards.yml");
        }
        this.scoreboardsConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardsConfigFile);
        ScoreboardHelper._recallScoreboards();
        Bukkit.getServer().getPluginManager().callEvent((Event)new SavesReloadEvent());
    }

    public FileConfiguration getSaves() {
        if (this.savesConfig == null) {
            this.reloadSaves();
        }
        return this.savesConfig;
    }

    public FileConfiguration getScoreboards() {
        if (this.scoreboardsConfig == null) {
            this.reloadSaves();
        }
        return this.scoreboardsConfig;
    }

    public void saveSaves() {
        if (this.savesConfig == null || this.savesConfigFile == null) {
            return;
        }
        try {
            dLocation._saveLocations();
            ScoreboardHelper._saveScoreboards();
            this.savesConfig.save(this.savesConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.savesConfigFile, ex);
        }
        try {
            this.scoreboardsConfig.save(this.scoreboardsConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.scoreboardsConfigFile, ex);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        if (this.citizens == null) {
            this.citizens = (Citizens)this.getServer().getPluginManager().getPlugin("Citizens");
        }
        if (cmdName.equalsIgnoreCase("ex")) {
            ArrayList<String> entries = new ArrayList<String>();
            String entry = "";
            for (String arg : args) {
                entry = entry + arg + " ";
            }
            if (entry.length() < 2) {
                sender.sendMessage("/ex <dCommand> (arguments)");
                return true;
            }
            entries.add(entry);
            InstantQueue queue = InstantQueue.getQueue(null);
            NPC npc = this.citizens.getNPCSelector().getSelected(sender);
            List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, sender instanceof Player ? dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)sender)) : null, npc != null ? new dNPC(npc) : null);
            queue.addEntries(scriptEntries);
            queue.start();
            return true;
        }
        return this.citizens.onCommand(sender, cmd, cmdName, args);
    }
}

