/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;

public class InventoryCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnumList(Action.values())) {
                scriptEntry.addObject("actions", ((dList)arg.asType(dList.class)).filter(Action.values()));
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin, o, source, s, items, item, i, from, f") && (arg.matchesArgumentTypes(dInventory.class, dEntity.class, dLocation.class) || arg.matchesArgumentList(dItem.class))) {
                scriptEntry.addObject("origin", Conversion.getInventory(arg));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination, dest, d, target, to, t") && arg.matchesArgumentTypes(dInventory.class, dEntity.class, dLocation.class)) {
                scriptEntry.addObject("destination", Conversion.getInventory(arg));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify an Inventory action!");
        }
        scriptEntry.defaultObject("destination", scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity().getInventory() : null);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List actions = (List)scriptEntry.getObject("actions");
        dInventory origin = (dInventory)scriptEntry.getObject("origin");
        dInventory destination = (dInventory)scriptEntry.getObject("destination");
        dB.report(scriptEntry, this.getName(), aH.debugObj("actions", actions.toString()) + destination.debug() + (origin != null ? origin.debug() : ""));
        for (String action : actions) {
            switch (Action.valueOf(action.toUpperCase())) {
                case OPEN: {
                    if (destination.getIdHolder().equalsIgnoreCase("workbench")) {
                        scriptEntry.getPlayer().getPlayerEntity().openWorkbench((Location)destination.getLocation(), true);
                        break;
                    }
                    scriptEntry.getPlayer().getPlayerEntity().openInventory(destination.getInventory());
                    break;
                }
                case COPY: {
                    origin.replace(destination);
                    break;
                }
                case MOVE: {
                    origin.replace(destination);
                    origin.clear();
                    break;
                }
                case SWAP: {
                    dInventory temp = new dInventory(destination.getInventoryType()).add(destination.getContents());
                    origin.replace(destination);
                    temp.replace(origin);
                    break;
                }
                case ADD: {
                    destination.add(origin.getContents());
                    break;
                }
                case REMOVE: {
                    destination.remove(origin.getContents());
                    break;
                }
                case KEEP: {
                    destination.keep(origin.getContents());
                    break;
                }
                case EXCLUDE: {
                    destination.exclude(origin.getContents());
                    break;
                }
                case FILL: {
                    destination.fill(origin.getContents());
                    break;
                }
                case CLEAR: {
                    destination.clear();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        OPEN,
        COPY,
        MOVE,
        SWAP,
        ADD,
        REMOVE,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR;

    }
}

