/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties;

import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.objects.properties.PropertyParser;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Zombie;

public class EntityAge
implements Property {
    dEntity ageable;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        return ((dEntity)entity).getBukkitEntity() instanceof Ageable || ((dEntity)entity).getBukkitEntity().getType() == EntityType.ZOMBIE;
    }

    public static EntityAge getFrom(dObject entity) {
        if (!EntityAge.describes(entity)) {
            return null;
        }
        return new EntityAge((dEntity)entity);
    }

    private EntityAge(dEntity entity) {
        this.ageable = entity;
    }

    public boolean isBaby() {
        if (this.ageable.getBukkitEntity().getType() == EntityType.ZOMBIE) {
            return ((Zombie)this.ageable.getBukkitEntity()).isBaby();
        }
        return !((Ageable)this.ageable.getBukkitEntity()).isAdult();
    }

    public void setBaby(boolean bool) {
        dB.log(this.ageable.isNPC() + " <--- is NPC?");
        if (this.ageable.isNPC()) {
            NPC ageable_npc = this.ageable.getNPC();
            if (!ageable_npc.hasTrait(Age.class)) {
                ageable_npc.addTrait(Age.class);
            }
            ((Age)ageable_npc.getTrait(Age.class)).setAge(bool ? -24000 : 1);
        } else if (this.ageable.getBukkitEntity().getType() == EntityType.ZOMBIE) {
            ((Zombie)this.ageable.getBukkitEntity()).setBaby(bool);
        } else if (bool) {
            ((Ageable)this.ageable.getBukkitEntity()).setBaby();
        } else {
            ((Ageable)this.ageable.getBukkitEntity()).setAge(1);
        }
    }

    public void setAge(int val) {
        if (this.ageable.isNPC()) {
            NPC ageable_npc = this.ageable.getNPC();
            ((Age)ageable_npc.getTrait(Age.class)).setAge(val);
        } else if (this.ageable.getBukkitEntity().getType() == EntityType.ZOMBIE) {
            ((Zombie)this.ageable.getBukkitEntity()).setBaby(val >= 1);
        } else {
            ((Ageable)this.ageable.getBukkitEntity()).setAge(val);
        }
    }

    public int getAge() {
        if (this.ageable.getBukkitEntity().getType() == EntityType.ZOMBIE) {
            return ((Zombie)this.ageable.getBukkitEntity()).isBaby() ? 0 : 1;
        }
        return ((Ageable)this.ageable.getBukkitEntity()).getAge();
    }

    public void setLock(boolean bool) {
        if (this.ageable.getBukkitEntity().getType() != EntityType.ZOMBIE) {
            ((Ageable)this.ageable.getBukkitEntity()).setAgeLock(bool);
        }
    }

    public boolean getLock() {
        if (this.ageable.getBukkitEntity().getType() == EntityType.ZOMBIE) {
            return true;
        }
        return ((Ageable)this.ageable.getBukkitEntity()).getAgeLock();
    }

    public String getPropertyString() {
        if (this.getAge() != 1) {
            return this.getPropertyId() + '=' + (this.getAge() == 0 ? "baby" : Integer.valueOf(this.getAge() + 59));
        }
        return PropertyParser.NONE;
    }

    public String getPropertyId() {
        return "age";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("age")) {
            return new Element(this.getAge()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_baby")) {
            return new Element(this.isBaby()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

