/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBuilder {
    public static List<ScriptEntry> addObjectToEntries(List<ScriptEntry> scriptEntryList, String key, Object obj) {
        for (ScriptEntry entry : scriptEntryList) {
            entry.addObject(key, obj);
            entry.trackObject(key);
        }
        return scriptEntryList;
    }

    public static List<ScriptEntry> buildScriptEntries(List<String> contents, ScriptContainer parent, dPlayer player, dNPC npc) {
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        if (contents == null || contents.isEmpty()) {
            if (dB.showScriptBuilder) {
                dB.echoError("Building script entries... no entries to build!");
            }
            return null;
        }
        if (dB.showScriptBuilder) {
            dB.echoDebug((Debuggable)parent, "Building script entries:");
        }
        for (String entry : contents) {
            String[] scriptEntry = new String[2];
            if (entry.split(" ", 2).length == 1) {
                scriptEntry[0] = entry;
                scriptEntry[1] = null;
            } else {
                scriptEntry = entry.split(" ", 2);
            }
            try {
                Object[] args = aH.buildArgs(scriptEntry[1]);
                if (dB.showScriptBuilder) {
                    dB.echoDebug((Debuggable)parent, "Adding '" + scriptEntry[0] + "'  Args: " + Arrays.toString(args));
                }
                ScriptEntry newEntry = new ScriptEntry(scriptEntry[0], (String[])args, parent).setPlayer(player).setNPC(npc);
                scriptCommands.add(newEntry);
            }
            catch (Exception e) {
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
        return scriptCommands;
    }
}

