/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Adjustable;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.Mechanism;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;

public class AdjustCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("object")) {
                scriptEntry.addObject("object", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("mechanism")) continue;
            if (arg.hasPrefix()) {
                scriptEntry.addObject("mechanism", new Element(arg.getPrefix().getValue()));
                scriptEntry.addObject("mechanism_value", arg.asElement());
                continue;
            }
            scriptEntry.addObject("mechanism", arg.asElement());
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String object = scriptEntry.getElement("object").asString();
        Class object_class = ObjectFetcher.getObjectClass(object.split("@")[0]);
        if (object_class == null) {
            throw new CommandExecutionException("Unfetchable object found '" + object + '\'');
        }
        if (!ObjectFetcher.checkMatch(object_class, object)) {
            throw new CommandExecutionException('\'' + object + "' is returning null.");
        }
        dObject fetched = ObjectFetcher.getObjectFrom(object_class, object);
        if (!(fetched instanceof Adjustable)) {
            throw new CommandExecutionException('\'' + object + "' is not adjustable.");
        }
        ((Adjustable)((Object)fetched)).adjust(new Mechanism(scriptEntry.getElement("mechanism").asString()), scriptEntry.getElement("mechanism_value"));
    }
}

