/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.events.ScriptFailEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class FailCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (arg.matchesArgumentType(dPlayer.class)) {
                scriptEntry.addObject("player", arg.asType(dPlayer.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("player", scriptEntry.getPlayer());
        scriptEntry.defaultObject("script", scriptEntry.getScript());
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getObject("script");
        dPlayer player = (dPlayer)scriptEntry.getObject("player");
        dB.report(scriptEntry, this.getName(), player.debug() + script.debug());
        FailCommand.failScript(player.getName(), script.getName());
    }

    public static void resetFails(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        DenizenAPI._saves().set("Players." + playerName + "." + scriptName + "." + "Failed", null);
    }

    public static void failScript(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        int fails = DenizenAPI._saves().getInt("Players." + playerName + "." + scriptName + "." + "Failed", 0);
        DenizenAPI._saves().set("Players." + playerName + "." + scriptName + "." + "Failed", (Object)(++fails));
        ScriptFailEvent event = new ScriptFailEvent(playerName, scriptName, fails);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public static int getScriptFails(String playerName, String scriptName) {
        return DenizenAPI.getCurrentInstance().getSaves().getInt("Players." + playerName + "." + scriptName.toUpperCase() + "." + "Failed", 0);
    }
}

