/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.BracedCommand;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ForEachCommand
extends BracedCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (scriptEntry.hasObject("list") || !arg.matchesArgumentType(dList.class)) continue;
            scriptEntry.addObject("list", arg.asType(dList.class));
        }
        if (!scriptEntry.hasObject("list")) {
            throw new InvalidArgumentsException("Must specify a valid list!");
        }
        scriptEntry.addObject("braces", this.getBracedCommands(scriptEntry, 1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dList list = (dList)scriptEntry.getObject("list");
        ArrayList bracedCommands = (ArrayList)((LinkedHashMap)scriptEntry.getObject("braces")).get("FOREACH");
        if (bracedCommands == null || bracedCommands.isEmpty()) {
            dB.echoError("Empty braces!");
            return;
        }
        dB.report(scriptEntry, this.getName(), list.debug());
        String queueId = UUID.randomUUID().toString();
        for (String value : list) {
            if (scriptEntry.getResidingQueue().getWasCleared()) {
                return;
            }
            ArrayList<ScriptEntry> newEntries = new ArrayList<ScriptEntry>();
            for (ScriptEntry entry : bracedCommands) {
                try {
                    ScriptEntry toAdd = entry.clone();
                    toAdd.getObjects().clear();
                    newEntries.add(toAdd);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            InstantQueue queue = new InstantQueue(queueId);
            for (Map.Entry<String, dObject> entry : scriptEntry.getResidingQueue().getAllContext().entrySet()) {
                queue.addContext(entry.getKey(), entry.getValue());
            }
            queue.addDefinition("parent_queue", scriptEntry.getResidingQueue().id);
            scriptEntry.getResidingQueue().addDefinition("value", value);
            queue.addDefinition("value", value);
            queue.getAllDefinitions().putAll(scriptEntry.getResidingQueue().getAllDefinitions());
            queue.addEntries(newEntries);
            queue.start();
        }
    }
}

