/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;

public class ResetCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dScript script = scriptEntry.getScript();
        Type type = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("finishes, finished, finish", arg)) {
                type = Type.FINISH;
                continue;
            }
            if (aH.matchesArg("fail, fails, failed", arg)) {
                type = Type.FAIL;
                continue;
            }
            if (aH.matchesArg("cooldown", arg)) {
                type = Type.PLAYER_COOLDOWN;
                continue;
            }
            if (aH.matchesArg("global_cooldown", arg)) {
                type = Type.GLOBAL_COOLDOWN;
                continue;
            }
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException("Unknown argument '" + arg + "'!");
        }
        if (type == null) {
            throw new InvalidArgumentsException("Must specify a type! Valid: FAILS, FINISHES, COOLDOWN, GLOBAL_COOLDOWN");
        }
        if (scriptEntry.getPlayer() == null && type != Type.GLOBAL_COOLDOWN) {
            throw new InvalidArgumentsException("Must specify a player!");
        }
        scriptEntry.addObject("script", script).addObject("type", (Object)type);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        dScript script = (dScript)scriptEntry.getObject("script");
        switch (type) {
            case FAIL: {
                FailCommand.resetFails(scriptEntry.getPlayer().getName(), script.getName());
                return;
            }
            case FINISH: {
                FinishCommand.resetFinishes(scriptEntry.getPlayer().getName(), script.getName());
                return;
            }
            case PLAYER_COOLDOWN: {
                CooldownCommand.setCooldown(scriptEntry.getPlayer().getName(), Duration.ZERO, script.getName(), false);
                return;
            }
            case GLOBAL_COOLDOWN: {
                CooldownCommand.setCooldown(scriptEntry.getPlayer().getName(), Duration.ZERO, script.getName(), true);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        FINISH,
        FAIL,
        PLAYER_COOLDOWN,
        GLOBAL_COOLDOWN;

    }
}

