/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Player;

public class AnimateCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
            }
            if (scriptEntry.hasObject("animation") || scriptEntry.hasObject("effect")) continue;
            if (arg.matchesEnum((Enum[])PlayerAnimation.values())) {
                scriptEntry.addObject("animation", PlayerAnimation.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (!arg.matchesEnum((Enum[])EntityEffect.values())) continue;
            scriptEntry.addObject("effect", EntityEffect.valueOf((String)arg.getValue().toUpperCase()));
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("effect") && !scriptEntry.hasObject("animation")) {
            throw new InvalidArgumentsException("Must specify a valid animation!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        PlayerAnimation animation = scriptEntry.hasObject("animation") ? (PlayerAnimation)scriptEntry.getObject("animation") : null;
        EntityEffect effect = scriptEntry.hasObject("effect") ? (EntityEffect)scriptEntry.getObject("effect") : null;
        dB.report(scriptEntry, this.getName(), (animation != null ? aH.debugObj("animation", animation.name()) : aH.debugObj("effect", effect.name())) + aH.debugObj("entities", entities.toString()));
        block0: for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            if (animation != null && entity.getBukkitEntity() instanceof Player) {
                PlayerAnimation[] animationArray;
                Player player = (Player)entity.getBukkitEntity();
                for (PlayerAnimation current : animationArray = (PlayerAnimation[])PlayerAnimation.class.getEnumConstants()) {
                    if (!current.equals((Object)animation)) continue;
                    current.play(player);
                    continue block0;
                }
                continue;
            }
            entity.getBukkitEntity().playEffect(effect);
        }
    }
}

