/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class HealthCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("target") && arg.matches("player")) {
                if (!scriptEntry.hasPlayer()) {
                    throw new InvalidArgumentsException("No player attached!");
                }
                scriptEntry.addObject("target", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("state")) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("qty") && !scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a quantity!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (!scriptEntry.hasNPC()) {
                throw new InvalidArgumentsException("Missing NPC!");
            }
            scriptEntry.addObject("target", Element.valueOf("npc"));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element qty = scriptEntry.getElement("qty");
        Element action = scriptEntry.getElement("action");
        boolean isplayer = scriptEntry.getElement("target").asString().equalsIgnoreCase("player");
        dB.report(scriptEntry, this.getName(), (qty != null ? qty.debug() : "") + (action != null ? action.debug() : ""));
        if (qty == null && action == null) {
            dB.echoError("Null quantity!");
        }
        if (action != null) {
            if (action.asString().equalsIgnoreCase("true")) {
                scriptEntry.getNPC().getCitizen().addTrait(HealthTrait.class);
            } else if (action.asString().equalsIgnoreCase("false")) {
                scriptEntry.getNPC().getCitizen().removeTrait(HealthTrait.class);
            } else if (scriptEntry.getNPC().getCitizen().hasTrait(HealthTrait.class)) {
                scriptEntry.getNPC().getCitizen().removeTrait(HealthTrait.class);
            } else {
                scriptEntry.getNPC().getCitizen().addTrait(HealthTrait.class);
            }
        }
        if (qty != null) {
            if (isplayer) {
                scriptEntry.getPlayer().getPlayerEntity().setMaxHealth(qty.asDouble());
            } else if (scriptEntry.getNPC().getCitizen().hasTrait(HealthTrait.class)) {
                scriptEntry.getNPC().getHealthTrait().setMaxhealth(qty.asInt());
            } else {
                dB.echoError("NPC doesn't have health trait!");
            }
        }
    }
}

