/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.FishingTrait;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

public class FishCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dLocation location = null;
        Boolean stopping = false;
        Boolean catchFish = false;
        int catchPercent = 65;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug((Debuggable)scriptEntry, "...location set");
                continue;
            }
            if (aH.matchesArg("CATCHFISH", arg)) {
                catchFish = true;
                dB.echoDebug((Debuggable)scriptEntry, "...npc will catch fish");
                continue;
            }
            if (aH.matchesArg("STOP", arg)) {
                stopping = true;
                dB.echoDebug((Debuggable)scriptEntry, "...stopping");
                continue;
            }
            if (aH.matchesValueArg("CATCHPERCENT, PERCENT", arg, aH.ArgumentType.Integer)) {
                catchPercent = aH.getIntegerFrom(arg);
                dB.echoDebug((Debuggable)scriptEntry, "...set catch percent: " + catchPercent);
                continue;
            }
            throw new InvalidArgumentsException("Unknown argument '" + arg + "'");
        }
        scriptEntry.addObject("location", location).addObject("stopping", stopping).addObject("catchFish", catchFish).addObject("catchPercent", catchPercent);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Boolean stopping = (Boolean)scriptEntry.getObject("stopping");
        Boolean catchFish = (Boolean)scriptEntry.getObject("catchFish");
        int catchPercent = (Integer)scriptEntry.getObject("catchPercent");
        NPC npc = scriptEntry.getNPC().getCitizen();
        FishingTrait trait = new FishingTrait();
        if (!npc.hasTrait(FishingTrait.class)) {
            npc.addTrait(FishingTrait.class);
        }
        if (stopping.booleanValue()) {
            trait.stopFishing();
            return;
        }
        Location location = (Location)scriptEntry.getObject("location");
        if (location == null) {
            dB.echoError("...no location specified!");
            return;
        }
        trait.startFishing(location);
        trait.setCatchPercent(catchPercent);
        if (catchFish.booleanValue()) {
            trait.setCatchFish(true);
        }
    }
}

