/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

public class TriggerCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String trigger = null;
        Toggle toggle = Toggle.TOGGLE;
        Duration cooldown = new Duration(-1.0);
        int radius = -1;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("COOLDOWN", arg, aH.ArgumentType.Duration)) {
                cooldown = aH.getDurationFrom(arg);
                cooldown.setPrefix("Cooldown");
                continue;
            }
            if (aH.matchesValueArg("RADIUS", arg, aH.ArgumentType.Integer)) {
                radius = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesState(arg)) {
                toggle = Toggle.valueOf(aH.getStringFrom(arg.toUpperCase()));
                continue;
            }
            if (aH.matchesValueArg("NAME", arg, aH.ArgumentType.String)) {
                trigger = aH.getStringFrom(arg);
                continue;
            }
            if (this.denizen.getTriggerRegistry().get(arg) != null) {
                trigger = aH.getStringFrom(arg);
                continue;
            }
            dB.echoError("Unknown argument '" + arg + "'");
        }
        if (trigger == null) {
            throw new InvalidArgumentsException("Missing name argument!");
        }
        scriptEntry.addObject("trigger", trigger);
        scriptEntry.addObject("cooldown", cooldown);
        scriptEntry.addObject("toggle", (Object)toggle);
        scriptEntry.addObject("radius", radius);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Toggle toggle = (Toggle)((Object)scriptEntry.getObject("toggle"));
        String trigger = (String)scriptEntry.getObject("trigger");
        Integer radius = (Integer)scriptEntry.getObject("radius");
        Duration cooldown = (Duration)scriptEntry.getObject("cooldown");
        NPC npc = scriptEntry.getNPC().getCitizen();
        dB.echoApproval("Executing '" + this.getName() + "': " + "Trigger='" + trigger + "', " + "Toggle='" + toggle.toString() + "', " + (radius > 0 ? "Radius='" + radius + "', " : "Radius='Unchanged', ") + (cooldown.getSeconds() > 0.0 ? "Cooldown='" + cooldown.debug() + "', " : "Cooldown='Unchanged', ") + "NPC='" + scriptEntry.getNPC() + "'");
        if (!npc.hasTrait(TriggerTrait.class)) {
            npc.addTrait(TriggerTrait.class);
        }
        TriggerTrait trait = (TriggerTrait)npc.getTrait(TriggerTrait.class);
        if (toggle == Toggle.TOGGLE) {
            trait.toggleTrigger(trigger);
        } else if (toggle == Toggle.TRUE) {
            trait.toggleTrigger(trigger, true);
        } else {
            trait.toggleTrigger(trigger, false);
        }
        if (radius > 0) {
            trait.setLocalRadius(trigger, radius);
        }
        if (cooldown.getSeconds() > 0.0) {
            trait.setLocalCooldown(trigger, cooldown.getSeconds());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Toggle {
        TOGGLE,
        TRUE,
        FALSE;

    }
}

