/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.utilities.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParticleEffect {
    HUGE_EXPLOSION("hugeexplosion", 0),
    LARGE_EXPLODE("largeexplode", 1),
    FIREWORKS_SPARK("fireworksSpark", 2),
    BUBBLE("bubble", 3),
    SUSPEND("suspend", 4),
    DEPTH_SUSPEND("depthSuspend", 5),
    TOWN_AURA("townaura", 6),
    CRIT("crit", 7),
    MAGIC_CRIT("magicCrit", 8),
    MOB_SPELL("mobSpell", 9),
    MOB_SPELL_AMBIENT("mobSpellAmbient", 10),
    SPELL("spell", 11),
    INSTANT_SPELL("instantSpell", 12),
    WITCH_MAGIC("witchMagic", 13),
    NOTE("note", 14),
    PORTAL("portal", 15),
    ENCHANTMENT_TABLE("enchantmenttable", 16),
    EXPLODE("explode", 17),
    FLAME("flame", 18),
    LAVA("lava", 19),
    FOOTSTEP("footstep", 20),
    SPLASH("splash", 21),
    LARGE_SMOKE("largesmoke", 22),
    CLOUD("cloud", 23),
    RED_DUST("reddust", 24),
    SNOWBALL_POOF("snowballpoof", 25),
    DRIP_WATER("dripWater", 26),
    DRIP_LAVA("dripLava", 27),
    SNOW_SHOVEL("snowshovel", 28),
    SLIME("slime", 29),
    HEART("heart", 30),
    ANGRY_VILLAGER("angryVillager", 31),
    HAPPY_VILLAGER("happyVillager", 32),
    RANDOM("random", 33);

    private String name;
    private int id;
    private static final Map<String, ParticleEffect> NAME_MAP;
    private static final Map<Integer, ParticleEffect> ID_MAP;

    private ParticleEffect(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static ParticleEffect fromName(String name) {
        if (name == null) {
            return null;
        }
        for (Map.Entry<String, ParticleEffect> e : NAME_MAP.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(name)) continue;
            return e.getValue();
        }
        return null;
    }

    public static ParticleEffect fromId(int id) {
        return ID_MAP.get(id);
    }

    public void play(Player p, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        ParticleEffect.sendPacket(p, this.createNormalPacket(this, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public void play(Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        Object packet = this.createNormalPacket(this, loc, offsetX, offsetY, offsetZ, speed, amount);
        for (Player p : loc.getWorld().getPlayers()) {
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public void play(Location loc, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        Object packet = this.createNormalPacket(this, loc, offsetX, offsetY, offsetZ, speed, amount);
        for (Player p : loc.getWorld().getPlayers()) {
            if (!(p.getLocation().distance(loc) <= range)) continue;
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public static void playTileCrack(Player p, Location loc, int id, byte data, float offsetX, float offsetY, float offsetZ, int amount) {
        ParticleEffect.sendPacket(p, ParticleEffect.createTileCrackPacket(id, data, loc, offsetX, offsetY, offsetZ, amount));
    }

    public static void playTileCrack(Location loc, int id, byte data, float offsetX, float offsetY, float offsetZ, int amount) {
        Object packet = ParticleEffect.createTileCrackPacket(id, data, loc, offsetX, offsetY, offsetZ, amount);
        for (Player p : loc.getWorld().getPlayers()) {
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public static void playTileCrack(Location loc, double range, int id, byte data, float offsetX, float offsetY, float offsetZ, int amount) {
        Object packet = ParticleEffect.createTileCrackPacket(id, data, loc, offsetX, offsetY, offsetZ, amount);
        for (Player p : loc.getWorld().getPlayers()) {
            if (!(p.getLocation().distance(loc) <= range)) continue;
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public static void playIconCrack(Player p, Location loc, int id, float offsetX, float offsetY, float offsetZ, int amount) {
        ParticleEffect.sendPacket(p, ParticleEffect.createIconCrackPacket(id, loc, offsetX, offsetY, offsetZ, amount));
    }

    public static void playIconCrack(Location loc, int id, float offsetX, float offsetY, float offsetZ, int amount) {
        Object packet = ParticleEffect.createIconCrackPacket(id, loc, offsetX, offsetY, offsetZ, amount);
        for (Player p : loc.getWorld().getPlayers()) {
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public static void playIconCrack(Location loc, double range, int id, float offsetX, float offsetY, float offsetZ, int amount) {
        Object packet = ParticleEffect.createIconCrackPacket(id, loc, offsetX, offsetY, offsetZ, amount);
        for (Player p : loc.getWorld().getPlayers()) {
            if (!(p.getLocation().distance(loc) <= range)) continue;
            ParticleEffect.sendPacket(p, packet);
        }
    }

    private Object createNormalPacket(ParticleEffect effect, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (effect.equals((Object)RANDOM)) {
            while (effect.toString().matches("^(RANDOM|BUBBLE|SUSPEND|DEPTH_SUSPEND)$")) {
                effect = ParticleEffect.values()[Utilities.getRandom().nextInt(ParticleEffect.values().length)];
            }
        }
        return ParticleEffect.createPacket(effect.getName(), loc, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static Object createTileCrackPacket(int id, byte data, Location loc, float offsetX, float offsetY, float offsetZ, int amount) {
        return ParticleEffect.createPacket("tilecrack_" + id + "_" + data, loc, offsetX, offsetY, offsetZ, 0.1f, amount);
    }

    private static Object createIconCrackPacket(int id, Location loc, float offsetX, float offsetY, float offsetZ, int amount) {
        return ParticleEffect.createPacket("iconcrack_" + id, loc, offsetX, offsetY, offsetZ, 0.1f, amount);
    }

    private static Object createPacket(String effectName, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        try {
            if (amount <= 0) {
                throw new IllegalArgumentException("Amount of particles has to be greater than 0!");
            }
            Object packet = ReflectionUtil.getClass("Packet63WorldParticles", new Object[0]);
            ReflectionUtil.setValue(packet, "a", effectName);
            ReflectionUtil.setValue(packet, "b", Float.valueOf((float)loc.getX()));
            ReflectionUtil.setValue(packet, "c", Float.valueOf((float)loc.getY()));
            ReflectionUtil.setValue(packet, "d", Float.valueOf((float)loc.getZ()));
            ReflectionUtil.setValue(packet, "e", Float.valueOf(offsetX));
            ReflectionUtil.setValue(packet, "f", Float.valueOf(offsetY));
            ReflectionUtil.setValue(packet, "g", Float.valueOf(offsetZ));
            ReflectionUtil.setValue(packet, "h", Float.valueOf(speed));
            ReflectionUtil.setValue(packet, "i", amount);
            return packet;
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[ParticleEffect] Failed to create a particle packet!");
            return null;
        }
    }

    private static void sendPacket(Player p, Object packet) {
        if (packet == null) {
            return;
        }
        try {
            Object entityPlayer = ReflectionUtil.getMethod("getHandle", p.getClass(), 0).invoke((Object)p, new Object[0]);
            Object playerConnection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
            ReflectionUtil.getMethod("sendPacket", playerConnection.getClass(), 1).invoke(playerConnection, packet);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[ParticleEffect] Failed to send a particle packet to " + p.getName() + "!");
        }
    }

    static {
        NAME_MAP = new HashMap<String, ParticleEffect>();
        ID_MAP = new HashMap<Integer, ParticleEffect>();
        for (ParticleEffect effect : ParticleEffect.values()) {
            NAME_MAP.put(effect.name, effect);
            ID_MAP.put(effect.id, effect);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectionUtil {
        private ReflectionUtil() {
        }

        public static Object getClass(String name, Object ... args) throws Exception {
            Class<?> c = Class.forName(ReflectionUtil.getPackageName() + "." + name);
            int params = 0;
            if (args != null) {
                params = args.length;
            }
            for (Constructor<?> co : c.getConstructors()) {
                if (co.getParameterTypes().length != params) continue;
                return co.newInstance(args);
            }
            return null;
        }

        public static Method getMethod(String name, Class<?> c, int params) {
            for (Method m : c.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != params) continue;
                return m;
            }
            return null;
        }

        public static void setValue(Object instance, String fieldName, Object value) throws Exception {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }

        public static String getPackageName() {
            return "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
    }
}

