/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.javaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer {
    private Pattern pattern;
    private String tokenDelimiters;

    Tokenizer(List<String> delimiters) {
        if (this.onlyOneChar(delimiters)) {
            StringBuilder builder = new StringBuilder();
            for (String delimiter : delimiters) {
                builder.append(delimiter);
            }
            this.tokenDelimiters = builder.toString();
        } else {
            this.pattern = Tokenizer.delimitersToRegexp(delimiters);
        }
    }

    private boolean onlyOneChar(List<String> delimiters) {
        for (String delimiter : delimiters) {
            if (delimiter.length() == 1) continue;
            return false;
        }
        return true;
    }

    private static Pattern delimitersToRegexp(List<String> delimiters) {
        Collections.sort(delimiters, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -o1.compareTo(o2);
            }
        });
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (String delim : delimiters) {
            if (result.length() != 1) {
                result.append('|');
            }
            for (int i = 0; i < delim.length(); ++i) {
                result.append('\\');
                result.append(delim.charAt(i));
            }
        }
        result.append(')');
        return Pattern.compile(result.toString());
    }

    Iterator<String> tokenize(String string) {
        if (this.pattern != null) {
            ArrayList<String> res = new ArrayList<String>();
            Matcher m = this.pattern.matcher(string);
            int pos = 0;
            while (m.find()) {
                if (pos != m.start()) {
                    res.add(string.substring(pos, m.start()));
                }
                res.add(m.group());
                pos = m.end();
            }
            if (pos != string.length()) {
                res.add(string.substring(pos));
            }
            return res.iterator();
        }
        final StringTokenizer tokens = new StringTokenizer(string, this.tokenDelimiters, true);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokens.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokens.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

