/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.SmartEvent;
import net.aufdemrand.denizen.events.bukkit.ScriptReloadEvent;
import net.aufdemrand.denizen.events.core.EntitySpawnSmartEvent;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager
implements Listener {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>(8, 0.9f, 1);
    public static Map<String, List<WorldScriptContainer>> events = new HashMap<String, List<WorldScriptContainer>>();
    public static Set<SmartEvent> smart_events = new HashSet<SmartEvent>();
    private Plugin plugin = DenizenAPI.getCurrentInstance();

    public EventManager() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void scanWorldEvents(ScriptReloadEvent event) {
        for (WorldScriptContainer script : world_scripts.values()) {
            if (script == null || !script.contains("EVENTS")) continue;
            for (String eventName : script.getConfigurationSection("EVENTS").getKeys(false)) {
                List<Object> list = events.containsKey(eventName) ? events.get(eventName) : new ArrayList();
                list.add(script);
                events.put(eventName, list);
            }
        }
        for (SmartEvent smartEvent : smart_events) {
            smartEvent.breakDown();
        }
        for (SmartEvent smartEvent : smart_events) {
            if (!smartEvent.shouldInitialize(events.keySet())) continue;
            smartEvent._initialize();
        }
    }

    public void registerCommand(String ... aliases) {
        PluginCommand command = EventManager.getCommand(aliases[0], this.plugin);
        command.setAliases(Arrays.asList(aliases));
        EventManager.getCommandMap().register(this.plugin.getDescription().getName(), (Command)command);
    }

    private static PluginCommand getCommand(String name, Plugin plugin) {
        PluginCommand command = null;
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            c.setAccessible(true);
            command = (PluginCommand)c.newInstance(name, plugin);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return command;
    }

    private static CommandMap getCommandMap() {
        CommandMap commandMap = null;
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field f = SimplePluginManager.class.getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
            }
        }
        catch (NoSuchFieldException e) {
            dB.echoError(e);
        }
        catch (SecurityException e) {
            dB.echoError(e);
        }
        catch (IllegalArgumentException e) {
            dB.echoError(e);
        }
        catch (IllegalAccessException e) {
            dB.echoError(e);
        }
        return commandMap;
    }

    public static List<String> trimEvents(List<String> event) {
        ArrayList<String> parsed = new ArrayList<String>();
        if (dB.showEventsTrimming) {
            dB.echoApproval("Trimming world events '" + event.toString() + '\'');
        }
        for (String e : event) {
            if (!events.containsKey("ON " + e.toUpperCase())) continue;
            parsed.add(e);
        }
        return parsed;
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, dObject> context, boolean usesIdentifiers) {
        return EventManager.doEvents(usesIdentifiers ? EventManager.addAlternates(eventNames) : eventNames, npc, player, context);
    }

    public static List<String> addAlternates(List<String> events) {
        HashSet<String> newEvents = new HashSet<String>();
        for (String event : events) {
            if (!event.matches(".*?[a-z]{1,2}@[\\w ]+")) continue;
            newEvents.add(event.replaceAll("[a-z]{1,2}@", ""));
        }
        ArrayList<String> finalEvents = new ArrayList<String>();
        finalEvents.addAll(events);
        finalEvents.addAll(newEvents);
        return finalEvents;
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, dObject> context) {
        String determination = "none";
        eventNames = EventManager.trimEvents(eventNames);
        for (String eventName : eventNames) {
            if (!events.containsKey("ON " + eventName.toUpperCase())) continue;
            for (WorldScriptContainer script : events.get("ON " + eventName.toUpperCase())) {
                List<ScriptEntry> entries;
                if (script == null || (entries = script.getEntries(player != null ? new dPlayer((OfflinePlayer)player) : null, npc, "events.on " + eventName)).isEmpty()) continue;
                dB.report(script, "Event", aH.debugObj("Type", "on " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
                dB.echoDebug(script, dB.DebugElement.Header, "Building event 'ON " + eventName.toUpperCase() + "' for " + script.getName());
                long id = DetermineCommand.getNewId();
                ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                ScriptQueue queue = InstantQueue.getQueue(null).addEntries(entries);
                if (context != null) {
                    for (Map.Entry<String, dObject> entry : context.entrySet()) {
                        queue.addContext(entry.getKey(), entry.getValue());
                    }
                }
                queue.start();
                if (!DetermineCommand.hasOutcome(id)) continue;
                determination = DetermineCommand.getOutcome(id);
            }
        }
        return determination;
    }

    public void registerCoreMembers() {
        EventManager.registerSmartEvent(new EntitySpawnSmartEvent());
    }

    public static void registerSmartEvent(SmartEvent event) {
        if (event != null) {
            smart_events.add(event);
        }
    }
}

